/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.scheduling.TaskUtils;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStarted;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStoppedCanceled;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStoppedDone;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStoppedFailed;
import org.sonatype.nexus.web.internal.BaseUrlDetector;
import org.sonatype.scheduling.AbstractSchedulerTask;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.TaskInterruptedException;
import org.sonatype.scheduling.TaskState;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public abstract class AbstractNexusTask<T>
extends AbstractSchedulerTask<T>
implements NexusTask<T> {
    public static final long A_DAY = 86400000L;
    private EventBus eventBus;
    private BaseUrlDetector baseUrlDetector;

    protected AbstractNexusTask() {
        this(null);
    }

    protected AbstractNexusTask(String name) {
        if (name == null || name.trim().length() == 0) {
            TaskUtils.setName(this, this.getClass().getSimpleName());
        } else {
            TaskUtils.setName(this, name);
        }
    }

    protected AbstractNexusTask(EventBus eventBus, String name) {
        this(name);
        this.eventBus = eventBus;
    }

    protected EventBus getEventBus() {
        Preconditions.checkState((this.eventBus != null ? 1 : 0) != 0);
        return this.eventBus;
    }

    @Inject
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Inject
    public void setBaseUrlDetector(BaseUrlDetector baseUrlDetector) {
        this.baseUrlDetector = baseUrlDetector;
    }

    protected final void notifyEventListeners(Object event) {
        this.eventBus.post(event);
    }

    @Override
    public boolean isExposed() {
        return true;
    }

    @Override
    public String getId() {
        return this.getParameter(".id");
    }

    @Override
    public String getName() {
        return this.getParameter(".name");
    }

    @Override
    public boolean shouldSendAlertEmail() {
        String alertEmail = this.getAlertEmail();
        return alertEmail != null && alertEmail.trim().length() > 0;
    }

    @Override
    public String getAlertEmail() {
        return this.getParameter(".alertEmail");
    }

    public boolean allowConcurrentSubmission(Map<String, List<ScheduledTask<?>>> activeTasks) {
        return true;
    }

    public boolean allowConcurrentExecution(Map<String, List<ScheduledTask<?>>> activeTasks) {
        if (activeTasks.containsKey(this.getClass().getSimpleName())) {
            for (ScheduledTask<?> task : activeTasks.get(this.getClass().getSimpleName())) {
                if (!TaskState.RUNNING.equals((Object)task.getTaskState())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public final T call() throws Exception {
        this.getLogger().info(this.getLoggedMessage("started"));
        long started = System.currentTimeMillis();
        if (this.baseUrlDetector != null) {
            this.baseUrlDetector.set();
        }
        NexusTaskEventStarted startedEvent = new NexusTaskEventStarted(this);
        this.getEventBus().post(startedEvent);
        T result = null;
        try {
            this.beforeRun();
            result = this.doRun();
            if (TaskUtil.getCurrentProgressListener().isCanceled()) {
                this.getLogger().info(this.getLoggedMessage("canceled", started));
                this.getEventBus().post(new NexusTaskEventStoppedCanceled(this, startedEvent));
            } else {
                this.getLogger().info(this.getLoggedMessage("finished", started));
                this.getEventBus().post(new NexusTaskEventStoppedDone(this, startedEvent));
            }
            this.afterRun();
            return result;
        }
        catch (Throwable e) {
            if (e instanceof TaskInterruptedException) {
                this.getLogger().info(this.getLoggedMessage("canceled", started));
                this.getEventBus().post(new NexusTaskEventStoppedCanceled(this, startedEvent));
                return null;
            }
            this.getLogger().warn(this.getLoggedMessage("failed", started), e);
            this.getEventBus().post(new NexusTaskEventStoppedFailed(this, startedEvent, e));
            Throwables.propagateIfInstanceOf((Throwable)e, Exception.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected String getLoggedMessage(String action) {
        return String.format("Scheduled task (%s) %s :: %s", this.getName(), action, this.getMessage());
    }

    protected String getLoggedMessage(String action, long started) {
        String startedStr = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(started);
        String durationStr = DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - started));
        return String.format("%s (started %s, runtime %s)", this.getLoggedMessage(action), startedStr, durationStr);
    }

    protected void beforeRun() throws Exception {
    }

    protected abstract T doRun() throws Exception;

    protected void afterRun() throws Exception {
    }

    protected abstract String getAction();

    protected abstract String getMessage();
}

