/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusTask;
import org.sonatype.scheduling.DefaultScheduledTask;
import org.sonatype.scheduling.ScheduledTask;

public abstract class AbstractNexusRepositoriesTask<T>
extends AbstractNexusTask<T> {
    private RepositoryRegistry repositoryRegistry;

    @Inject
    public void setRepositoryRegistry(RepositoryRegistry repositoryRegistry) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    protected RepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    public String getRepositoryId() {
        String id = (String)this.getParameters().get(this.getRepositoryFieldId());
        if ("all_repo".equals(id)) {
            return null;
        }
        return id;
    }

    public void setRepositoryId(String repositoryId) {
        if (!StringUtils.isEmpty((String)repositoryId)) {
            this.getParameters().put(this.getRepositoryFieldId(), repositoryId);
        }
    }

    public String getRepositoryName() {
        try {
            Repository repo = this.getRepositoryRegistry().getRepository(this.getRepositoryId());
            return repo.getName();
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Could not read repository!", (Throwable)e);
            return this.getRepositoryId();
        }
    }

    @Override
    public boolean allowConcurrentExecution(Map<String, List<ScheduledTask<?>>> activeTasks) {
        return !this.hasIntersectingTasksThatRuns(activeTasks);
    }

    protected boolean hasIntersectingTasksThatRuns(Map<String, List<ScheduledTask<?>>> activeTasks) {
        for (List<ScheduledTask<?>> scheduledTasks : activeTasks.values()) {
            for (ScheduledTask<?> task : scheduledTasks) {
                if (!AbstractNexusRepositoriesTask.class.isAssignableFrom(task.getTask().getClass()) || !task.getTaskState().isExecuting() || !DefaultScheduledTask.class.isAssignableFrom(task.getClass()) || !this.repositorySetIntersectionIsNotEmpty((String)task.getTaskParams().get(this.getRepositoryFieldId()))) continue;
                this.getLogger().debug("Task {} is already running and is conflicting with task {}", (Object)task.getName(), (Object)this.getClass().getSimpleName());
                return true;
            }
        }
        return false;
    }

    protected boolean repositorySetIntersectionIsNotEmpty(String repositoryId) {
        if (StringUtils.equals((String)this.getRepositoryId(), (String)repositoryId)) {
            return true;
        }
        if (this.getRepositoryId() == null || repositoryId == null) {
            return true;
        }
        try {
            ArrayList<Repository> thisReposes = new ArrayList<Repository>();
            Repository repo = this.getRepositoryRegistry().getRepository(this.getRepositoryId());
            if (repo.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
                thisReposes.addAll(repo.adaptToFacet(GroupRepository.class).getTransitiveMemberRepositories());
            } else {
                thisReposes.add(repo);
            }
            ArrayList<Repository> reposes = new ArrayList<Repository>();
            Repository repo2 = this.getRepositoryRegistry().getRepository(repositoryId);
            if (repo2.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
                reposes.addAll(repo2.adaptToFacet(GroupRepository.class).getTransitiveMemberRepositories());
            } else {
                reposes.add(repo2);
            }
            HashSet<Repository> testSet = new HashSet<Repository>();
            testSet.addAll(thisReposes);
            testSet.addAll(reposes);
            return thisReposes.size() + reposes.size() != testSet.size();
        }
        catch (NoSuchResourceStoreException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }
}

