/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repositories.metadata;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.mirror.PublishedMirrors;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.Mirror;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.repositories.metadata.NexusRawTransport;
import org.sonatype.nexus.repository.metadata.MetadataHandlerException;
import org.sonatype.nexus.repository.metadata.RawTransport;
import org.sonatype.nexus.repository.metadata.RepositoryMetadataHandler;
import org.sonatype.nexus.repository.metadata.model.RepositoryMemberMetadata;
import org.sonatype.nexus.repository.metadata.model.RepositoryMetadata;
import org.sonatype.nexus.repository.metadata.model.RepositoryMirrorMetadata;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class NexusRepositoryMetadataEventInspector
extends ComponentSupport
implements EventSubscriber {
    private final ContentClass maven1ContentClass;
    private final ContentClass maven2ContentClass;
    private final RepositoryMetadataHandler repositoryMetadataHandler;
    private final RepositoryRegistry repositoryRegistry;
    private final ApplicationStatusSource applicationStatusSource;

    @Inject
    public NexusRepositoryMetadataEventInspector(@Named(value="maven1") ContentClass maven1ContentClass, @Named(value="maven2") ContentClass maven2ContentClass, RepositoryMetadataHandler repositoryMetadataHandler, RepositoryRegistry repositoryRegistry, ApplicationStatusSource applicationStatusSource) {
        this.maven1ContentClass = maven1ContentClass;
        this.maven2ContentClass = maven2ContentClass;
        this.repositoryMetadataHandler = repositoryMetadataHandler;
        this.repositoryRegistry = repositoryRegistry;
        this.applicationStatusSource = applicationStatusSource;
    }

    @Subscribe
    public void on(NexusStartedEvent evt) {
        this.inspect(evt);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryRegistryEventAdd evt) {
        this.inspect(evt);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryConfigurationUpdatedEvent evt) {
        this.inspect(evt);
    }

    protected void inspect(Event<?> evt) {
        if (evt instanceof NexusStartedEvent) {
            for (Repository repository : this.repositoryRegistry.getRepositories()) {
                this.processRepository(repository);
            }
            return;
        }
        if (!this.applicationStatusSource.getSystemStatus().isNexusStarted()) {
            return;
        }
        if (evt instanceof RepositoryRegistryEventAdd) {
            this.processRepository(((RepositoryRegistryEventAdd)evt).getRepository());
        } else if (evt instanceof RepositoryConfigurationUpdatedEvent) {
            this.processRepository(((RepositoryConfigurationUpdatedEvent)evt).getRepository());
        }
    }

    protected void processRepository(Repository repository) {
        if (repository.getRepositoryContentClass().isCompatible(this.maven2ContentClass) || repository.getRepositoryContentClass().isCompatible(this.maven1ContentClass)) {
            if (LocalStatus.OUT_OF_SERVICE.equals((Object)repository.getLocalStatus())) {
                return;
            }
            String repositoryUrl = null;
            String repositoryLocalUrl = null;
            List<RepositoryMirrorMetadata> mirrors = null;
            if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
                repositoryUrl = this.getRepositoryLocalUrl(repository);
                repositoryLocalUrl = null;
            } else if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
                MavenRepository mrepository = repository.adaptToFacet(MavenRepository.class);
                if (mrepository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
                    repositoryUrl = mrepository.adaptToFacet(ProxyRepository.class).getRemoteUrl();
                    repositoryLocalUrl = this.getRepositoryLocalUrl(mrepository);
                } else {
                    repositoryUrl = this.getRepositoryLocalUrl(mrepository);
                    repositoryLocalUrl = null;
                }
            } else {
                return;
            }
            if (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class)) {
                mirrors = this.getMirrors(repository.getId());
            }
            RepositoryMetadata rm = new RepositoryMetadata();
            rm.setUrl(repositoryUrl);
            rm.setId(repository.getId());
            rm.setName(repository.getName());
            rm.setLayout(repository.getRepositoryContentClass().getId());
            rm.setPolicy(this.getRepositoryPolicy(repository));
            rm.setMirrors(mirrors);
            if (repositoryLocalUrl != null) {
                rm.setLocalUrl(repositoryLocalUrl);
            }
            if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
                List<Repository> members = repository.adaptToFacet(GroupRepository.class).getMemberRepositories();
                ArrayList<RepositoryMemberMetadata> memberMetadatas = new ArrayList<RepositoryMemberMetadata>(members.size());
                for (Repository member : members) {
                    RepositoryMemberMetadata memberMetadata = new RepositoryMemberMetadata();
                    memberMetadata.setId(member.getId());
                    memberMetadata.setName(member.getName());
                    memberMetadata.setUrl(this.getRepositoryLocalUrl(member));
                    memberMetadata.setPolicy(this.getRepositoryPolicy(member));
                    memberMetadatas.add(memberMetadata);
                }
                rm.getMemberRepositories().addAll(memberMetadatas);
            }
            try {
                NexusRawTransport nrt = new NexusRawTransport(repository, true, false);
                this.repositoryMetadataHandler.writeRepositoryMetadata(rm, (RawTransport)nrt);
                StorageFileItem file = nrt.getLastWriteFile();
                file.setContentGeneratorId("NexusRepositoryMetadataContentGenerator");
                repository.getAttributesHandler().storeAttributes(file);
            }
            catch (MetadataHandlerException e) {
                this.log.info("Could not write repository metadata!", (Throwable)e);
            }
            catch (IOException e) {
                this.log.warn("IOException during write of repository metadata!", (Throwable)e);
            }
            catch (Exception e) {
                this.log.info("Could not save repository metadata: ", (Throwable)e);
            }
        }
    }

    protected String getRepositoryLocalUrl(Repository repository) {
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            return "@rootUrl@/content/groups/" + repository.getId();
        }
        return "@rootUrl@/content/repositories/" + repository.getId();
    }

    protected String getRepositoryPolicy(Repository repository) {
        if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
            return repository.adaptToFacet(MavenRepository.class).getRepositoryPolicy().toString().toLowerCase();
        }
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            List<Repository> members = repository.adaptToFacet(GroupRepository.class).getMemberRepositories();
            HashSet<String> memberPolicies = new HashSet<String>();
            for (Repository member : members) {
                memberPolicies.add(this.getRepositoryPolicy(member));
            }
            if (memberPolicies.size() == 1) {
                return (String)memberPolicies.iterator().next();
            }
            return "mixed";
        }
        return "mixed";
    }

    protected List<RepositoryMirrorMetadata> getMirrors(String repositoryId) {
        try {
            ArrayList<RepositoryMirrorMetadata> mirrors = new ArrayList<RepositoryMirrorMetadata>();
            Repository repository = this.repositoryRegistry.getRepository(repositoryId);
            PublishedMirrors publishedMirrors = repository.getPublishedMirrors();
            for (Mirror mirror : publishedMirrors.getMirrors()) {
                RepositoryMirrorMetadata md = new RepositoryMirrorMetadata();
                md.setId(mirror.getId());
                md.setUrl(mirror.getUrl());
                mirrors.add(md);
            }
            return mirrors;
        }
        catch (NoSuchRepositoryException e) {
            this.log.debug("Repository not found, returning no mirrors");
            return null;
        }
    }
}

