/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repositories.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.ContentGenerator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.util.io.StreamSupport;
import org.sonatype.nexus.web.BaseUrlHolder;

@Named(value="NexusRepositoryMetadataContentGenerator")
@Singleton
public class NexusRepositoryMetadataContentGenerator
implements ContentGenerator {
    public static final String ID = "NexusRepositoryMetadataContentGenerator";

    @Override
    public String getGeneratorId() {
        return ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ContentLocator generateContent(Repository repository, String path, StorageFileItem item) throws IllegalOperationException, ItemNotFoundException, StorageException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (InputStream is = item.getInputStream();){
            StreamSupport.copy(is, bos, StreamSupport.BUFFER_SIZE);
            String body = new String(bos.toByteArray(), "UTF-8");
            StringContentLocator result = null;
            result = BaseUrlHolder.isSet() ? new StringContentLocator(body.replace("@rootUrl@", BaseUrlHolder.get())) : new StringContentLocator(body.replace("@rootUrl@", ""));
            StringContentLocator stringContentLocator = result;
            return stringContentLocator;
        }
        catch (IOException e) {
            throw new LocalStorageException(e);
        }
    }
}

