/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repositories.metadata;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ByteArrayContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.repository.metadata.RawTransport;
import org.sonatype.nexus.util.io.StreamSupport;

public class NexusRawTransport
implements RawTransport {
    private final Repository repository;
    private final boolean localOnly;
    private final boolean remoteOnly;
    private StorageFileItem lastReadFile;
    private StorageFileItem lastWriteFile;

    public NexusRawTransport(Repository repository, boolean localOnly, boolean remoteOnly) {
        this.repository = repository;
        this.localOnly = localOnly;
        this.remoteOnly = remoteOnly;
    }

    public byte[] readRawData(String path) throws Exception {
        try {
            ResourceStoreRequest request = new ResourceStoreRequest(path, this.localOnly, this.remoteOnly);
            StorageItem item = this.repository.retrieveItem(false, request);
            if (item instanceof StorageFileItem) {
                StorageFileItem file = (StorageFileItem)item;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (InputStream is = file.getInputStream();){
                    StreamSupport.copy(is, os, StreamSupport.BUFFER_SIZE);
                }
                this.lastReadFile = file;
                return os.toByteArray();
            }
            return null;
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public void writeRawData(String path, byte[] data) throws Exception {
        DefaultStorageFileItem file = new DefaultStorageFileItem(this.repository, new ResourceStoreRequest(path), true, true, (ContentLocator)new ByteArrayContentLocator(data, "text/xml"));
        this.repository.storeItem(false, file);
        this.lastWriteFile = file;
    }

    public StorageFileItem getLastReadFile() {
        return this.lastReadFile;
    }

    public StorageFileItem getLastWriteFile() {
        return this.lastWriteFile;
    }
}

