/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repositories.metadata;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.sonatype.nexus.repository.metadata.RawTransport;

public class Hc4RawTransport
implements RawTransport {
    private final HttpClient httpClient;
    private final String baseUrl;

    public Hc4RawTransport(HttpClient httpClient, String baseUrl) {
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient);
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
    }

    public byte[] readRawData(String path) throws IOException {
        HttpGet get = new HttpGet(this.createUrlWithPath(path));
        get.setHeader("Accept", ContentType.APPLICATION_XML.getMimeType());
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 && response.getEntity() != null) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            if (statusCode == 404) {
                byte[] byArray = null;
                return byArray;
            }
            throw new IOException("The response was not successful: " + response.getStatusLine());
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRawData(String path, byte[] bytes) throws IOException {
        HttpPut put = new HttpPut(this.createUrlWithPath(path));
        put.setEntity((HttpEntity)new ByteArrayEntity(bytes, ContentType.APPLICATION_XML));
        HttpResponse response = this.httpClient.execute((HttpUriRequest)put);
        try {
            if (response.getStatusLine().getStatusCode() > 299) {
                throw new IOException("The response was not successful: " + response.getStatusLine());
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    protected String createUrlWithPath(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.baseUrl + (this.baseUrl.endsWith("/") ? "" : "/") + path;
    }
}

