/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repositories.metadata;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.repositories.metadata.Hc4RawTransport;
import org.sonatype.nexus.repositories.metadata.NexusRawTransport;
import org.sonatype.nexus.repositories.metadata.NexusRepositoryMetadataHandler;
import org.sonatype.nexus.repository.metadata.MetadataHandlerException;
import org.sonatype.nexus.repository.metadata.RawTransport;
import org.sonatype.nexus.repository.metadata.RepositoryMetadataHandler;
import org.sonatype.nexus.repository.metadata.model.RepositoryMetadata;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultNexusRepositoryMetadataHandler
extends ComponentSupport
implements NexusRepositoryMetadataHandler {
    private final RepositoryRegistry repositoryRegistry;
    private final RepositoryMetadataHandler repositoryMetadataHandler;
    private final Hc4Provider hc4Provider;

    @Inject
    public DefaultNexusRepositoryMetadataHandler(RepositoryRegistry repositoryRegistry, RepositoryMetadataHandler repositoryMetadataHandler, Hc4Provider hc4Provider) {
        this.repositoryRegistry = repositoryRegistry;
        this.repositoryMetadataHandler = repositoryMetadataHandler;
        this.hc4Provider = hc4Provider;
    }

    @Override
    public RepositoryMetadata readRemoteRepositoryMetadata(String url) throws MetadataHandlerException, IOException {
        Hc4RawTransport hc4RawTransport = new Hc4RawTransport(this.hc4Provider.createHttpClient(), url);
        return this.repositoryMetadataHandler.readRepositoryMetadata((RawTransport)hc4RawTransport);
    }

    @Override
    public RepositoryMetadata readRepositoryMetadata(String repositoryId) throws NoSuchRepositoryException, MetadataHandlerException, IOException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        NexusRawTransport nrt = new NexusRawTransport(repository, false, true);
        return this.repositoryMetadataHandler.readRepositoryMetadata((RawTransport)nrt);
    }

    @Override
    public void writeRepositoryMetadata(String repositoryId, RepositoryMetadata repositoryMetadata) throws NoSuchRepositoryException, MetadataHandlerException, IOException {
        Repository repository = this.repositoryRegistry.getRepository(repositoryId);
        NexusRawTransport nrt = new NexusRawTransport(repository, true, false);
        this.repositoryMetadataHandler.writeRepositoryMetadata(repositoryMetadata, (RawTransport)nrt);
    }
}

