/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.wastebasket;

import java.util.Collection;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.SilentWalker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerProcessor;

public class WastebasketWalker
extends AbstractWalkerProcessor
implements WalkerProcessor,
SilentWalker {
    private long age;

    public WastebasketWalker(long age) {
        this.age = age;
    }

    @Override
    public void processItem(WalkerContext ctx, StorageItem item) {
        long now = System.currentTimeMillis();
        long limitDate = now - this.age;
        if (item instanceof StorageFileItem && (this.age == -1L || item.getModified() < limitDate)) {
            try {
                ctx.getRepository().getLocalStorage().shredItem(ctx.getRepository(), item.getResourceStoreRequest());
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (UnsupportedStorageOperationException unsupportedStorageOperationException) {
            }
            catch (LocalStorageException localStorageException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onCollectionExit(WalkerContext ctx, StorageCollectionItem item) throws Exception {
        if (ctx.getResourceStoreRequest().getRequestPath().equals(item.getPath())) {
            return;
        }
        try {
            Collection<StorageItem> items = item.list();
            if (items.isEmpty()) {
                ctx.getRepository().getLocalStorage().shredItem(ctx.getRepository(), item.getResourceStoreRequest());
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }
}

