/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.wastebasket;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.local.LocalRepositoryStorage;
import org.sonatype.nexus.proxy.walker.AffirmativeStoreWalkerFilter;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;
import org.sonatype.nexus.proxy.wastebasket.Wastebasket;
import org.sonatype.nexus.proxy.wastebasket.WastebasketWalker;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultWastebasket
extends ComponentSupport
implements Wastebasket {
    private static final String DEFAULT_DELETE_OPERATION_KEY = DefaultWastebasket.class.getName() + ".defaultDeleteOperation";
    private static final String TRASH_PATH_PREFIX = "/.nexus/trash";
    protected static final long ALL = -1L;
    private final ApplicationConfiguration applicationConfiguration;
    private Walker walker;
    private final RepositoryRegistry repositoryRegistry;
    private DeleteOperation deleteOperation;

    @Inject
    public DefaultWastebasket(ApplicationConfiguration applicationConfiguration, Walker walker, RepositoryRegistry repositoryRegistry) {
        this.applicationConfiguration = applicationConfiguration;
        this.walker = walker;
        this.repositoryRegistry = repositoryRegistry;
        this.deleteOperation = this.getDefaultDeleteOperation();
    }

    protected DeleteOperation getDefaultDeleteOperation() {
        String defaultOperationString = SystemPropertiesHelper.getString(DEFAULT_DELETE_OPERATION_KEY, DeleteOperation.MOVE_TO_TRASH.name());
        try {
            return DeleteOperation.valueOf(defaultOperationString);
        }
        catch (Exception e) {
            this.log.warn("Bad value {}={}", new Object[]{DEFAULT_DELETE_OPERATION_KEY, defaultOperationString, e});
            return DeleteOperation.MOVE_TO_TRASH;
        }
    }

    protected ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    protected Walker getWalker() {
        return this.walker;
    }

    @VisibleForTesting
    void setWalker(Walker walker) {
        this.walker = walker;
    }

    protected RepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    @Override
    public DeleteOperation getDeleteOperation() {
        return this.deleteOperation;
    }

    @Override
    public void setDeleteOperation(DeleteOperation deleteOperation) {
        this.deleteOperation = deleteOperation;
    }

    @Override
    public Long getTotalSize() {
        Long totalSize = null;
        for (Repository repository : this.getRepositoryRegistry().getRepositories()) {
            Long repoWBSize = this.getSize(repository);
            if (repoWBSize == null) continue;
            totalSize = totalSize + repoWBSize;
        }
        return totalSize;
    }

    @Override
    public void purgeAll() throws IOException {
        this.purgeAll(-1L);
    }

    @Override
    public void purgeAll(final long age) throws IOException {
        for (Repository repository : this.getRepositoryRegistry().getRepositories()) {
            this.purge(repository, age);
        }
        final File basketFile = this.getApplicationConfiguration().getWorkingDirectory("trash");
        if (basketFile.isDirectory()) {
            final long limitDate = System.currentTimeMillis() - age;
            Files.walkFileTree(basketFile.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (age == -1L || file.toFile().lastModified() < limitDate) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!basketFile.equals(dir.toFile()) && dir.toFile().list().length == 0) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @Override
    public Long getSize(Repository repository) {
        return null;
    }

    @Override
    public void purge(Repository repository) throws IOException {
        this.purge(repository, -1L);
    }

    @Override
    public void purge(Repository repository, long age) throws IOException {
        ResourceStoreRequest req = new ResourceStoreRequest(this.getTrashPath(repository, "/"));
        if (repository.getLocalStorage().containsItem(repository, req)) {
            req.setRequestGroupLocalOnly(true);
            req.setRequestLocalOnly(true);
            DefaultWalkerContext ctx = new DefaultWalkerContext(repository, req, new AffirmativeStoreWalkerFilter());
            ctx.getProcessors().add(new WastebasketWalker(age));
            this.getWalker().walk(ctx);
        }
    }

    @Override
    public void delete(LocalRepositoryStorage ls, Repository repository, ResourceStoreRequest request) throws LocalStorageException {
        DeleteOperation operation = request.getRequestContext().containsKey(DeleteOperation.DELETE_OPERATION_CTX_KEY) ? (DeleteOperation)((Object)request.getRequestContext().get(DeleteOperation.DELETE_OPERATION_CTX_KEY)) : this.getDeleteOperation();
        this.delete(ls, repository, request, operation);
    }

    private void delete(LocalRepositoryStorage ls, Repository repository, ResourceStoreRequest request, DeleteOperation type) throws LocalStorageException {
        try {
            if (DeleteOperation.MOVE_TO_TRASH.equals((Object)type)) {
                ResourceStoreRequest trashed = new ResourceStoreRequest(this.getTrashPath(repository, request.getRequestPath()));
                ls.moveItem(repository, request, trashed);
            }
            ls.shredItem(repository, request);
        }
        catch (ItemNotFoundException trashed) {
        }
        catch (UnsupportedStorageOperationException e) {
            throw new LocalStorageException("Delete operation is unsupported!", e);
        }
    }

    @Override
    public boolean undelete(LocalRepositoryStorage ls, Repository repository, ResourceStoreRequest request) throws LocalStorageException {
        try {
            ResourceStoreRequest trashed = new ResourceStoreRequest(this.getTrashPath(repository, request.getRequestPath()));
            ResourceStoreRequest untrashed = new ResourceStoreRequest(this.getUnTrashPath(repository, request.getRequestPath()));
            if (!ls.containsItem(repository, untrashed)) {
                ls.moveItem(repository, trashed, untrashed);
                return true;
            }
        }
        catch (ItemNotFoundException trashed) {
        }
        catch (UnsupportedStorageOperationException e) {
            throw new LocalStorageException("Undelete operation is unsupported!", e);
        }
        return false;
    }

    protected String getTrashPath(Repository repository, String path) {
        if (path.startsWith(TRASH_PATH_PREFIX)) {
            return path;
        }
        if (path.startsWith("/")) {
            return TRASH_PATH_PREFIX + path;
        }
        return "/.nexus/trash/" + path;
    }

    protected String getUnTrashPath(Repository repository, String path) {
        String result = path;
        if (result.startsWith(TRASH_PATH_PREFIX)) {
            result = result.substring(TRASH_PATH_PREFIX.length(), result.length());
        }
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }
}

