/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.wastebasket;

import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.wastebasket.RepositoryFolderCleaner;
import org.sonatype.nexus.proxy.wastebasket.RepositoryFolderRemover;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultRepositoryFolderRemover
extends ComponentSupport
implements RepositoryFolderRemover {
    private final Map<String, RepositoryFolderCleaner> cleaners;

    @Inject
    public DefaultRepositoryFolderRemover(Map<String, RepositoryFolderCleaner> cleaners) {
        this.cleaners = cleaners;
    }

    @Override
    public void deleteRepositoryFolders(Repository repository, boolean deleteForever) throws IOException {
        this.log.debug("Removing folders of repository \"{}\" (ID={})", (Object)repository.getName(), (Object)repository.getId());
        for (RepositoryFolderCleaner cleaner : this.cleaners.values()) {
            try {
                cleaner.cleanRepositoryFolders(repository, deleteForever);
            }
            catch (Exception e) {
                this.log.warn("Got exception during execution of RepositoryFolderCleaner {}, continuing.", (Object)cleaner.getClass().getName(), (Object)e);
            }
        }
    }
}

