/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.wastebasket;

import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.wastebasket.AbstractRepositoryFolderCleaner;

@Named(value="core-storage")
@Singleton
public class CoreRepositoryFolderCleaner
extends AbstractRepositoryFolderCleaner {
    @Override
    public void cleanRepositoryFolders(Repository repository, boolean deleteForever) throws IOException {
        File defaultStorageFolder = new File(new File(this.getApplicationConfiguration().getWorkingDirectory(), "storage"), repository.getId());
        String defaultStorageURI = defaultStorageFolder.toURI().toURL().toString();
        defaultStorageURI = defaultStorageURI.endsWith("/") ? defaultStorageURI : defaultStorageURI + "/";
        String localURI = repository.getLocalUrl();
        boolean defaultLocation = defaultStorageURI.equals(localURI = localURI.endsWith("/") ? localURI : localURI + "/");
        if (defaultLocation) {
            this.delete(defaultStorageFolder, deleteForever);
        }
    }
}

