/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.wastebasket;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.proxy.wastebasket.RepositoryFolderCleaner;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractRepositoryFolderCleaner
extends ComponentSupport
implements RepositoryFolderCleaner {
    public static final String GLOBAL_TRASH_KEY = "trash";
    private ApplicationConfiguration applicationConfiguration;

    @Inject
    public void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    protected ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    protected void delete(File file, boolean deleteForever) throws IOException {
        File basketFile = new File(this.getApplicationConfiguration().getWorkingDirectory(GLOBAL_TRASH_KEY), file.getName());
        if (!deleteForever) {
            DirSupport.moveIfExists(file.toPath(), basketFile.toPath());
        } else {
            DirSupport.deleteIfExists(file.toPath());
        }
    }
}

