/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.walker;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

public class PredicatePathWalkerFilter
implements WalkerFilter {
    private final Predicate<String> itemPredicate;
    private final Predicate<String> collectionPredicate;
    private final PathExtractor pathExtractor;
    public static final PathExtractor ITEM_PATH_EXTRACTOR = new PathExtractor(){

        @Override
        public String extractItemPath(StorageItem item) {
            return item.getPath();
        }

        @Override
        public String extractCollectionItemPath(StorageCollectionItem coll) {
            return this.extractItemPath(coll);
        }
    };

    public PredicatePathWalkerFilter(PathExtractor pathExtractor, Predicate<String> itemPredicate) {
        this(pathExtractor, itemPredicate, (Predicate<String>)Predicates.alwaysTrue());
    }

    public PredicatePathWalkerFilter(PathExtractor pathExtractor, Predicate<String> itemPredicate, Predicate<String> collectionPredicate) {
        this.pathExtractor = (PathExtractor)Preconditions.checkNotNull((Object)pathExtractor, (Object)"PathExtractor is null!");
        this.itemPredicate = (Predicate)Preconditions.checkNotNull(itemPredicate, (Object)"Item predicate is null!");
        this.collectionPredicate = (Predicate)Preconditions.checkNotNull(collectionPredicate, (Object)"Collection predicate is null!");
    }

    @Override
    public boolean shouldProcess(WalkerContext context, StorageItem item) {
        return this.itemPredicate.apply((Object)this.pathExtractor.extractItemPath(item));
    }

    @Override
    public boolean shouldProcessRecursively(WalkerContext context, StorageCollectionItem coll) {
        return this.collectionPredicate.apply((Object)this.pathExtractor.extractCollectionItemPath(coll));
    }

    public static interface PathExtractor {
        public String extractItemPath(StorageItem var1);

        public String extractCollectionItemPath(StorageCollectionItem var1);
    }
}

