/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.walker;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.util.Node;
import org.sonatype.nexus.util.PathUtils;

public class ParentOMatic {
    private final boolean keepMarkedNodesOnly;
    private final boolean applyRuleA;
    private final boolean applyRuleB;
    private final Node<Payload> ROOT;

    public ParentOMatic() {
        this(true);
    }

    public ParentOMatic(boolean keepMarkedNodesOnly) {
        this(keepMarkedNodesOnly, true, true);
    }

    public ParentOMatic(boolean keepMarkedNodesOnly, boolean applyRuleA, boolean applyRuleB) {
        this.keepMarkedNodesOnly = keepMarkedNodesOnly;
        this.applyRuleA = applyRuleA;
        this.applyRuleB = applyRuleB;
        this.ROOT = new Node<Payload>(null, "/", new Payload());
    }

    public Node<Payload> addPath(String path) {
        return this.addPath(path, true);
    }

    public void addAndMarkPath(String path) {
        Node<Payload> currentNode = this.addPath(path, false);
        if (this.applyRuleA) {
            this.applyRecursively(currentNode, new Function<Node<Payload>, Node<Payload>>(){

                public Node<Payload> apply(Node<Payload> input) {
                    input.getPayload().setMarked(false);
                    return input;
                }
            });
        }
        currentNode.getPayload().setMarked(true);
        Node<Payload> flippedNode = this.reorganizeForRecursion(currentNode);
        if (this.keepMarkedNodesOnly) {
            this.optimizeTreeSize(flippedNode);
        }
    }

    public List<String> getMarkedPaths() {
        final ArrayList<String> markedPaths = new ArrayList<String>();
        Function<Node<Payload>, Node<Payload>> markedCollector = new Function<Node<Payload>, Node<Payload>>(){

            public Node<Payload> apply(Node<Payload> input) {
                if (input.getPayload().isMarked()) {
                    markedPaths.add(input.getPath());
                }
                return null;
            }
        };
        this.applyRecursively(this.ROOT, markedCollector);
        return markedPaths;
    }

    public List<String> getAllLeafPaths() {
        final ArrayList<String> paths = new ArrayList<String>();
        Function<Node<Payload>, Node<Payload>> markedCollector = new Function<Node<Payload>, Node<Payload>>(){

            public Node<Payload> apply(Node<Payload> input) {
                if (input.isLeaf()) {
                    paths.add(input.getPath());
                }
                return null;
            }
        };
        this.applyRecursively(this.ROOT, markedCollector);
        return paths;
    }

    public void cutNodesDeeperThan(final int maxDepth) {
        this.applyRecursively(this.getRoot(), new Function<Node<Payload>, Node<Payload>>(){

            public Node<Payload> apply(Node<Payload> input) {
                if (input.getDepth() == maxDepth) {
                    for (Node<Payload> child : input.getChildren()) {
                        input.removeChild(child);
                    }
                }
                return null;
            }
        });
    }

    public Node<Payload> getRoot() {
        return this.ROOT;
    }

    public void applyRecursively(Node<Payload> fromNode, Function<Node<Payload>, Node<Payload>> modifier) {
        modifier.apply(fromNode);
        for (Node<Payload> child : fromNode.getChildren()) {
            this.applyRecursively(child, modifier);
        }
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        this.dump(this.ROOT, 0, sb);
        return sb.toString();
    }

    protected void dump(Node<Payload> node, int depth, StringBuilder sb) {
        sb.append(Strings.repeat((String)"  ", (int)depth));
        sb.append(node.getLabel());
        sb.append(" (").append(node.getPath()).append(")");
        if (node.getPayload().isMarked()) {
            sb.append("*");
        }
        sb.append("\n");
        for (Node<Payload> child : node.getChildren()) {
            this.dump(child, depth + 1, sb);
        }
    }

    protected Node<Payload> addPath(String path, boolean optimize) {
        List<String> pathElems = this.getPathElements((String)Preconditions.checkNotNull((Object)path));
        ArrayList actualPathElems = Lists.newArrayList();
        Node<Payload> currentNode = this.ROOT;
        for (String pathElem : pathElems) {
            actualPathElems.add(pathElem);
            Node<Payload> node = currentNode.getChildByLabel(pathElem);
            if (node == null) {
                currentNode = currentNode.addChild(pathElem, new Payload());
                continue;
            }
            currentNode = node;
        }
        if (optimize) {
            this.optimizeTreeSize(currentNode);
        }
        return currentNode;
    }

    protected Node<Payload> reorganizeForRecursion(Node<Payload> changedNode) {
        if (this.applyRuleA && this.isParentMarked(changedNode)) {
            changedNode.getPayload().setMarked(false);
            return changedNode.getParent();
        }
        if (this.applyRuleB && this.isParentAllChildMarkedForRuleB(changedNode)) {
            changedNode.getParent().getPayload().setMarked(true);
            for (Node<Payload> child : changedNode.getParent().getChildren()) {
                child.getPayload().setMarked(false);
            }
            return changedNode.getParent();
        }
        return changedNode;
    }

    protected void optimizeTreeSize(Node<Payload> changedNode) {
        for (Node<Payload> child : changedNode.getChildren()) {
            changedNode.removeChild(child);
        }
    }

    protected boolean isParentMarked(Node<Payload> node) {
        Node<Payload> parent = node.getParent();
        if (parent != null) {
            if (parent.getPayload().isMarked()) {
                return true;
            }
            return this.isParentMarked(parent);
        }
        return false;
    }

    protected boolean isParentAllChildMarkedForRuleB(Node<Payload> node) {
        Node<Payload> parent = node.getParent();
        if (parent != null) {
            List<Node<Payload>> children = parent.getChildren();
            if (children.size() < 2) {
                return false;
            }
            for (Node<Payload> child : children) {
                if (child.getPayload().isMarked()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<String> getPathElements(String path) {
        return PathUtils.elementsOf(path);
    }

    public static class Payload {
        private boolean marked = false;

        public boolean isMarked() {
            return this.marked;
        }

        public void setMarked(boolean marked) {
            this.marked = marked;
        }
    }
}

