/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.walker;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.sonatype.nexus.proxy.walker.AbstractWalkerThrottleController;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerThrottleController;
import org.sonatype.nexus.util.NumberSequence;

public class FixedRateWalkerThrottleController
extends AbstractWalkerThrottleController {
    private final NumberSequence currentSleepTime;
    private final FixedRateWalkerThrottleControllerCallback callback;
    private int globalAverageTps;
    private int globalMaximumTps;
    private int limiterTps;
    private long lastAdjustmentTimestamp;
    private long lastSliceSize;
    private long lastAdjustmentProcessItemInvocationCount;
    private int lastSliceTps;
    private long sliceSize;

    public FixedRateWalkerThrottleController(int limiterTps, NumberSequence numberSequence) throws IllegalArgumentException {
        this(limiterTps, numberSequence, null);
    }

    public FixedRateWalkerThrottleController(int limiterTps, NumberSequence numberSequence, FixedRateWalkerThrottleControllerCallback callback) throws IllegalArgumentException {
        this.limiterTps = limiterTps;
        numberSequence.reset();
        Preconditions.checkArgument((numberSequence.peek() >= 0L ? 1 : 0) != 0, (Object)"Passed in NumberSequence in reset state must have a non-negative peek() return value!");
        this.currentSleepTime = numberSequence;
        this.callback = callback;
        this.sliceSize = TimeUnit.SECONDS.toMillis(2L);
    }

    public int getGlobalAverageTps() {
        return this.globalAverageTps;
    }

    public int getGlobalMaximumTps() {
        return this.globalMaximumTps;
    }

    public int getLastSliceTps() {
        return this.lastSliceTps;
    }

    public long getCurrentSleepTime() {
        return this.currentSleepTime.peek();
    }

    public int getLimiterTps() {
        return this.limiterTps;
    }

    public void setLimiterTps(int limiterTps) {
        this.limiterTps = limiterTps;
    }

    public long getSliceSize() {
        return this.sliceSize;
    }

    public void setSliceSize(long sliceSize) {
        Preconditions.checkArgument((sliceSize > 0L ? 1 : 0) != 0);
        this.sliceSize = sliceSize;
    }

    @Override
    public void walkStarted(WalkerContext context) {
        this.globalAverageTps = 0;
        this.globalMaximumTps = 0;
        this.lastSliceTps = 0;
        this.lastAdjustmentTimestamp = System.currentTimeMillis();
        this.lastAdjustmentProcessItemInvocationCount = 0L;
    }

    @Override
    public void walkEnded(WalkerContext context, WalkerThrottleController.ThrottleInfo info) {
        this.mayCalculateStats(info, true);
    }

    @Override
    public boolean isThrottled() {
        return this.limiterTps > -1;
    }

    @Override
    public long throttleTime(WalkerThrottleController.ThrottleInfo info) {
        if (this.mayCalculateStats(info, false)) {
            if (this.lastSliceTps > this.limiterTps) {
                if (this.currentSleepTime.peek() < 0L) {
                    this.currentSleepTime.reset();
                } else {
                    this.currentSleepTime.next();
                }
            } else if (this.currentSleepTime.peek() > 0L) {
                this.currentSleepTime.prev();
            }
            if (this.callback != null) {
                this.callback.onAdjustment(this);
            }
        }
        return this.currentSleepTime.peek();
    }

    protected boolean mayCalculateStats(WalkerThrottleController.ThrottleInfo info, boolean forced) {
        if (this.adjustmentNeeded(forced)) {
            this.globalAverageTps = this.calculateCPS(info.getTotalProcessItemInvocationCount(), info.getTotalTimeWalking());
            this.lastSliceTps = this.calculateCPS(info.getTotalProcessItemInvocationCount() - this.lastAdjustmentProcessItemInvocationCount, this.lastSliceSize);
            this.lastAdjustmentProcessItemInvocationCount = info.getTotalProcessItemInvocationCount();
            this.globalMaximumTps = Math.max(this.lastSliceTps, this.globalMaximumTps);
            return true;
        }
        return false;
    }

    protected boolean adjustmentNeeded(boolean forced) {
        long now = System.currentTimeMillis();
        long latestSlice = now - this.lastAdjustmentTimestamp;
        if (forced || latestSlice > this.sliceSize) {
            this.lastSliceSize = latestSlice;
            this.lastAdjustmentTimestamp = now;
            return true;
        }
        return false;
    }

    protected int calculateCPS(long count, long millis) {
        if (count == 0L) {
            return 0;
        }
        if (millis == 0L) {
            return -1;
        }
        return (int)((double)count / (double)millis * 1000.0);
    }

    public static interface FixedRateWalkerThrottleControllerCallback {
        public void onAdjustment(FixedRateWalkerThrottleController var1);
    }
}

