/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.walker;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;
import org.sonatype.nexus.proxy.walker.WalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerThrottleController;
import org.sonatype.scheduling.TaskInterruptedException;
import org.sonatype.scheduling.TaskUtil;

public class DefaultWalkerContext
implements WalkerContext {
    private final Repository resourceStore;
    private final WalkerFilter walkerFilter;
    private final ResourceStoreRequest request;
    private final WalkerThrottleController throttleController;
    private final WalkerContext.TraversalType traversalType;
    private final boolean processCollections;
    private final Map<String, Object> context;
    private final List<WalkerProcessor> processors;
    private Throwable stopCause;
    private Comparator<StorageItem> itemComparator;
    private volatile boolean running;

    public DefaultWalkerContext(Repository store, ResourceStoreRequest request) {
        this(store, request, null);
    }

    public DefaultWalkerContext(Repository store, ResourceStoreRequest request, WalkerFilter filter) {
        this(store, request, filter, WalkerContext.TraversalType.DEPTH_FIRST, false);
    }

    @Deprecated
    public DefaultWalkerContext(Repository store, ResourceStoreRequest request, WalkerFilter filter, boolean localOnly) {
        this(store, request, filter);
    }

    public DefaultWalkerContext(Repository store, ResourceStoreRequest request, @Nullable WalkerFilter filter, WalkerContext.TraversalType traversalType, boolean processCollections) {
        this.resourceStore = (Repository)Preconditions.checkNotNull((Object)store);
        this.request = (ResourceStoreRequest)Preconditions.checkNotNull((Object)request);
        this.walkerFilter = filter;
        this.running = true;
        this.throttleController = request.getRequestContext().containsKey(WalkerThrottleController.CONTEXT_KEY, false) ? (WalkerThrottleController)request.getRequestContext().get(WalkerThrottleController.CONTEXT_KEY, false) : WalkerThrottleController.NO_THROTTLING;
        this.traversalType = (WalkerContext.TraversalType)((Object)Preconditions.checkNotNull((Object)((Object)traversalType)));
        this.processCollections = processCollections;
        this.context = Maps.newHashMap();
        this.processors = Lists.newArrayList();
    }

    @Override
    public boolean isLocalOnly() {
        return this.request.isRequestLocalOnly();
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public List<WalkerProcessor> getProcessors() {
        return this.processors;
    }

    @Override
    public WalkerFilter getFilter() {
        return this.walkerFilter;
    }

    @Override
    public Repository getRepository() {
        return this.resourceStore;
    }

    @Override
    public WalkerContext.TraversalType getTraversalType() {
        return this.traversalType;
    }

    @Override
    public boolean isProcessCollections() {
        return this.processCollections;
    }

    @Override
    public ResourceStoreRequest getResourceStoreRequest() {
        return this.request;
    }

    @Override
    public boolean isStopped() {
        try {
            TaskUtil.checkInterruption();
        }
        catch (TaskInterruptedException e) {
            if (this.stopCause == null) {
                this.stopCause = e;
            }
            this.running = false;
        }
        return !this.running;
    }

    @Override
    public Throwable getStopCause() {
        return this.stopCause;
    }

    @Override
    public void stop(Throwable cause) {
        this.running = false;
        this.stopCause = cause;
    }

    @Override
    public WalkerThrottleController getThrottleController() {
        return this.throttleController;
    }

    @Override
    public Comparator<StorageItem> getItemComparator() {
        return this.itemComparator;
    }

    public void setItemComparator(Comparator<StorageItem> itemComparator) {
        this.itemComparator = itemComparator;
    }
}

