/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.walker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.proxy.walker.DefaultStoreWalkerFilter;
import org.sonatype.nexus.proxy.walker.DefaultThrottleInfo;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.proxy.walker.WalkerFilter;
import org.sonatype.nexus.proxy.walker.WalkerProcessor;
import org.sonatype.scheduling.TaskInterruptedException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultWalker
extends ComponentSupport
implements Walker {
    public static final String WALKER_WALKED_COLLECTION_COUNT = Walker.class.getSimpleName() + ".collCount";
    public static final String WALKER_WALKED_FROM_PATH = Walker.class.getSimpleName() + ".fromPath";
    public static final String WALKER_THROTTLE_INFO = Walker.class.getSimpleName() + ".throttleInfo";

    @Override
    public void walk(WalkerContext context) throws WalkerException {
        String fromPath;
        block13: {
            fromPath = context.getResourceStoreRequest().getRequestPath();
            if (fromPath == null) {
                fromPath = "/";
            }
            if (LocalStatus.OUT_OF_SERVICE == context.getRepository().getLocalStatus()) {
                this.log.info("Cannot walk, repository {} is out of service.", (Object)RepositoryStringUtils.getHumanizedNameString(context.getRepository()));
            } else {
                context.getContext().put(WALKER_WALKED_FROM_PATH, fromPath);
                context.getContext().put(WALKER_THROTTLE_INFO, new DefaultThrottleInfo());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Start walking on ResourceStore {} from path \"{}\".", (Object)RepositoryStringUtils.getHumanizedNameString(context.getRepository()), (Object)fromPath);
                }
                try {
                    this.beforeWalk(context);
                    if (context.isStopped()) break block13;
                    StorageItem item = context.getRepository().retrieveItem(true, context.getResourceStoreRequest());
                    WalkerFilter filter = context.getFilter() != null ? context.getFilter() : new DefaultStoreWalkerFilter();
                    try {
                        if (StorageCollectionItem.class.isAssignableFrom(item.getClass())) {
                            int collCount = this.walkRecursive(0, context, filter, (StorageCollectionItem)item);
                            context.getContext().put(WALKER_WALKED_COLLECTION_COUNT, collCount);
                        } else {
                            this.walkItem(context, filter, item);
                            context.getContext().put(WALKER_WALKED_COLLECTION_COUNT, 1);
                        }
                    }
                    catch (Exception e) {
                        context.stop(e);
                    }
                    if (!context.isStopped()) {
                        this.afterWalk(context);
                    }
                }
                catch (ItemNotFoundException ex) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ItemNotFound where walking should start, bailing out.", (Throwable)ex);
                    }
                    context.stop(ex);
                }
                catch (Exception ex) {
                    this.log.warn("Got exception while doing retrieve, bailing out.", (Throwable)ex);
                    context.stop(ex);
                }
            }
        }
        this.reportWalkEnd(context, fromPath);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void reportWalkEnd(WalkerContext context, String fromPath) throws WalkerException {
        if (!context.isStopped()) {
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("Finished walking on ResourceStore '" + context.getRepository().getId() + "' from path '" + context.getContext().get(WALKER_WALKED_FROM_PATH) + "'.");
            return;
        }
        if (context.getStopCause() == null) {
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("Walker was stopped programatically, not because of error.");
            return;
        }
        if (context.getStopCause() instanceof TaskInterruptedException) {
            this.log.info("Canceled walking on repository {} from path \"{}\", cause: {}", new Object[]{RepositoryStringUtils.getHumanizedNameString(context.getRepository()), fromPath, context.getStopCause().getMessage()});
            return;
        }
        if (context.getStopCause() instanceof ItemNotFoundException) {
            this.log.debug("Aborted walking on repository {} from path \"{}\", cause: {}", new Object[]{RepositoryStringUtils.getHumanizedNameString(context.getRepository()), fromPath, context.getStopCause().getMessage()});
            throw new WalkerException(context, "Aborted walking on repository ID='" + context.getRepository().getId() + "' from path='" + fromPath + "'.");
        }
        this.log.warn("Aborted walking on repository {} from path \"{}\", cause: {}", new Object[]{RepositoryStringUtils.getHumanizedNameString(context.getRepository()), fromPath, context.getStopCause().getMessage(), context.getStopCause()});
        throw new WalkerException(context, "Aborted walking on repository ID='" + context.getRepository().getId() + "' from path='" + fromPath + "'.");
    }

    protected final int walkRecursive(int collCount, WalkerContext context, WalkerFilter filter, StorageCollectionItem coll) throws AccessDeniedException, IllegalOperationException, StorageException {
        if (context.isStopped()) {
            return collCount;
        }
        boolean shouldProcess = filter.shouldProcess(context, coll);
        boolean shouldProcessRecursively = filter.shouldProcessRecursively(context, coll);
        if (!shouldProcess && !shouldProcessRecursively) {
            return collCount;
        }
        if (shouldProcess) {
            this.onCollectionEnter(context, coll);
            ++collCount;
        }
        if (context.isStopped()) {
            return collCount;
        }
        ArrayList collections = Lists.newArrayList();
        if (shouldProcessRecursively) {
            try {
                ArrayList ls = Lists.newArrayList(context.getRepository().list(false, coll));
                if (context.getItemComparator() != null) {
                    Collections.sort(ls, context.getItemComparator());
                }
                for (StorageItem i : ls) {
                    if (context.isProcessCollections() || !(i instanceof StorageCollectionItem)) {
                        this.walkItem(context, filter, i);
                        if (context.isStopped()) {
                            return collCount;
                        }
                    }
                    if (!(i instanceof StorageCollectionItem)) continue;
                    if (context.getTraversalType() == WalkerContext.TraversalType.DEPTH_FIRST) {
                        collCount = this.walkRecursive(collCount, context, filter, (StorageCollectionItem)i);
                        if (!context.isStopped()) continue;
                        return collCount;
                    }
                    collections.add((StorageCollectionItem)i);
                }
            }
            catch (ItemNotFoundException e) {
                this.log.debug("ItemNotFound not found while walking it, skipping.", (Throwable)e);
            }
        }
        if (shouldProcess) {
            this.onCollectionExit(context, coll);
        }
        if (context.getTraversalType() == WalkerContext.TraversalType.BREADTH_FIRST) {
            for (StorageCollectionItem collection : collections) {
                collCount = this.walkRecursive(collCount, context, filter, collection);
                if (!context.isStopped()) continue;
                break;
            }
        }
        return collCount;
    }

    protected void walkItem(WalkerContext context, WalkerFilter filter, StorageItem i) {
        if (filter.shouldProcess(context, i)) {
            this.processItem(context, i);
        }
    }

    protected void beforeWalk(WalkerContext context) {
        context.getThrottleController().walkStarted(context);
        try {
            for (WalkerProcessor processor : context.getProcessors()) {
                if (!processor.isActive()) continue;
                processor.beforeWalk(context);
                if (!context.isStopped()) continue;
                break;
            }
        }
        catch (Exception e) {
            context.stop(e);
        }
    }

    protected void onCollectionEnter(WalkerContext context, StorageCollectionItem coll) {
        try {
            for (WalkerProcessor processor : context.getProcessors()) {
                if (!processor.isActive()) continue;
                processor.onCollectionEnter(context, coll);
                if (!context.isStopped()) continue;
                break;
            }
        }
        catch (Exception e) {
            context.stop(e);
        }
    }

    protected void processItem(WalkerContext context, StorageItem item) {
        block5: {
            try {
                long throttleTime;
                DefaultThrottleInfo info = (DefaultThrottleInfo)context.getContext().get(WALKER_THROTTLE_INFO);
                info.enterProcessItem();
                for (WalkerProcessor processor : context.getProcessors()) {
                    if (!processor.isActive()) continue;
                    processor.processItem(context, item);
                    if (!context.isStopped()) continue;
                    break;
                }
                info.exitProcessItem();
                if (context.isStopped() || !context.getThrottleController().isThrottled() || (throttleTime = context.getThrottleController().throttleTime(info)) <= 0L) break block5;
                try {
                    Thread.sleep(throttleTime);
                }
                catch (InterruptedException e) {
                    throw new TaskInterruptedException("Thread \"" + Thread.currentThread().getName() + "\" is interrupted!", false);
                }
            }
            catch (Exception e) {
                context.stop(e);
            }
        }
    }

    protected void onCollectionExit(WalkerContext context, StorageCollectionItem coll) {
        try {
            for (WalkerProcessor processor : context.getProcessors()) {
                if (!processor.isActive()) continue;
                processor.onCollectionExit(context, coll);
                if (!context.isStopped()) continue;
                break;
            }
        }
        catch (Exception e) {
            context.stop(e);
        }
    }

    protected void afterWalk(WalkerContext context) {
        try {
            for (WalkerProcessor processor : context.getProcessors()) {
                if (!processor.isActive()) continue;
                processor.afterWalk(context);
                if (!context.isStopped()) continue;
                break;
            }
        }
        catch (Exception e) {
            context.stop(e);
        }
        context.getThrottleController().walkEnded(context, (DefaultThrottleInfo)context.getContext().get(WALKER_THROTTLE_INFO));
    }
}

