/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.walker;

import org.sonatype.nexus.proxy.walker.WalkerThrottleController;

public class DefaultThrottleInfo
implements WalkerThrottleController.ThrottleInfo {
    private final long walkStarted = this.now();
    private long totalProcessItemSpentMillis = 0L;
    private long totalProcessItemInvocationCount = 0L;
    private long lastProcessItemEnterTime;

    protected long now() {
        return System.currentTimeMillis();
    }

    public void enterProcessItem() {
        this.lastProcessItemEnterTime = this.now();
    }

    public void exitProcessItem() {
        this.totalProcessItemSpentMillis += this.now() - this.lastProcessItemEnterTime;
        ++this.totalProcessItemInvocationCount;
    }

    @Override
    public long getTotalProcessItemInvocationCount() {
        return this.totalProcessItemInvocationCount;
    }

    @Override
    public long getTotalTimeWalking() {
        return this.now() - this.walkStarted;
    }
}

