/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.walker;

import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

public class ConjunctionWalkerFilter
implements WalkerFilter {
    private final WalkerFilter[] m_filters;

    public ConjunctionWalkerFilter(WalkerFilter ... filters) {
        this.m_filters = filters;
    }

    @Override
    public boolean shouldProcess(WalkerContext context, StorageItem item) {
        if (this.m_filters == null || this.m_filters.length == 0) {
            return true;
        }
        for (WalkerFilter filter : this.m_filters) {
            if (filter.shouldProcess(context, item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldProcessRecursively(WalkerContext context, StorageCollectionItem coll) {
        if (this.m_filters == null || this.m_filters.length == 0) {
            return true;
        }
        for (WalkerFilter filter : this.m_filters) {
            if (filter.shouldProcessRecursively(context, coll)) continue;
            return false;
        }
        return true;
    }

    public static ConjunctionWalkerFilter satisfiesAllOf(WalkerFilter ... filters) {
        return new ConjunctionWalkerFilter(filters);
    }
}

