/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.RemoteConnectionSettings;
import org.sonatype.nexus.proxy.storage.remote.RemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.utils.UserAgentBuilder;
import org.sonatype.nexus.proxy.utils.UserAgentContributor;

@Named
@Singleton
public class DefaultUserAgentBuilder
implements UserAgentBuilder {
    private final ApplicationStatusSource applicationStatusSource;
    private final List<UserAgentContributor> contributors;
    private String platformEditionShort;
    private String userAgentPlatformInfo;

    @Inject
    public DefaultUserAgentBuilder(ApplicationStatusSource applicationStatusSource, List<UserAgentContributor> contributors) {
        this.applicationStatusSource = applicationStatusSource;
        this.contributors = contributors;
    }

    @Override
    public String formatGenericUserAgentString() {
        return this.getUserAgentPlatformInfo();
    }

    @Override
    public String formatRemoteRepositoryStorageUserAgentString(ProxyRepository repository, RemoteStorageContext ctx) {
        return this.ua(ctx, repository).toString();
    }

    @Override
    public String formatUserAgentString(RemoteStorageContext ctx) {
        return this.ua(ctx).toString();
    }

    private StringBuilder ua(RemoteStorageContext ctx) {
        return this.ua(ctx, null);
    }

    @VisibleForTesting
    StringBuilder ua(RemoteStorageContext ctx, ProxyRepository repository) {
        RemoteConnectionSettings remoteConnectionSettings;
        StringBuilder buf = new StringBuilder(this.getUserAgentPlatformInfo());
        if (repository != null) {
            RemoteRepositoryStorage rrs = repository.getRemoteStorage();
            buf.append(" ").append(rrs.getProviderId()).append("/").append(rrs.getVersion());
        }
        if (!StringUtils.isEmpty((String)(remoteConnectionSettings = ctx.getRemoteConnectionSettings()).getUserAgentCustomizationString())) {
            buf.append(" ").append(remoteConnectionSettings.getUserAgentCustomizationString());
        }
        for (UserAgentContributor contributor : this.contributors) {
            String contribution = contributor.getUserAgent(ctx, repository);
            if (StringUtils.isEmpty((String)contribution)) continue;
            buf.append(" ").append(contribution);
        }
        return buf;
    }

    protected synchronized String getUserAgentPlatformInfo() {
        SystemStatus status = this.applicationStatusSource.getSystemStatus();
        if (this.platformEditionShort == null || !this.platformEditionShort.equals(status.getEditionShort()) || this.userAgentPlatformInfo == null) {
            this.platformEditionShort = status.getEditionShort();
            this.userAgentPlatformInfo = "Nexus/" + status.getVersion() + " (" + status.getEditionShort() + "; " + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + "; " + System.getProperty("java.version") + ")";
        }
        return this.userAgentPlatformInfo;
    }
}

