/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.targets;

import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

public class TargetStoreWalkerFilter
implements WalkerFilter {
    private final Target target;

    public TargetStoreWalkerFilter(Target target) throws IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("The target cannot be null!");
        }
        this.target = target;
    }

    @Override
    public boolean shouldProcess(WalkerContext context, StorageItem item) {
        return this.target.isPathContained(item.getRepositoryItemUid().getRepository().getRepositoryContentClass(), item.getPath());
    }

    @Override
    public boolean shouldProcessRecursively(WalkerContext context, StorageCollectionItem coll) {
        return true;
    }
}

