/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.targets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonatype.nexus.proxy.targets.TargetMatch;

public class TargetSet {
    private final Set<TargetMatch> matches = new HashSet<TargetMatch>();
    private final Set<String> matchedRepositoryIds = new HashSet<String>();

    public Set<TargetMatch> getMatches() {
        return Collections.unmodifiableSet(this.matches);
    }

    public Set<String> getMatchedRepositoryIds() {
        return Collections.unmodifiableSet(this.matchedRepositoryIds);
    }

    public void addTargetMatch(TargetMatch tm) {
        for (TargetMatch t : this.matches) {
            if (!t.getTarget().equals(tm.getTarget()) || !t.getRepository().getId().equals(tm.getRepository().getId())) continue;
            return;
        }
        this.matches.add(tm);
        this.matchedRepositoryIds.add(tm.getRepository().getId());
    }

    public void addTargetSet(TargetSet ts) {
        if (ts == null) {
            return;
        }
        for (TargetMatch tm : ts.getMatches()) {
            this.addTargetMatch(tm);
        }
    }
}

