/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.targets;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.registry.ContentClass;

public class Target {
    private final String id;
    private final String name;
    private final ContentClass contentClass;
    private final Set<String> patternTexts;
    private final Set<Pattern> patterns;

    public Target(String id, String name, ContentClass contentClass, Collection<String> patternTexts) throws PatternSyntaxException {
        this.id = id;
        this.name = name;
        this.contentClass = contentClass;
        this.patternTexts = new HashSet<String>(patternTexts);
        this.patterns = new HashSet<Pattern>(patternTexts.size());
        for (String patternText : patternTexts) {
            this.patterns.add(Pattern.compile(patternText));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ContentClass getContentClass() {
        return this.contentClass;
    }

    public Set<String> getPatternTexts() {
        return Collections.unmodifiableSet(this.patternTexts);
    }

    public boolean isPathContained(ContentClass contentClass, String path) {
        if (StringUtils.equals((String)this.getContentClass().getId(), (String)contentClass.getId()) || this.getContentClass().isCompatible(contentClass) || contentClass.isCompatible(this.getContentClass())) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(path).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

