/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.targets;

import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.proxy.targets.TargetRegistry;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultTargetRegistryEventInspector
extends ComponentSupport
implements EventSubscriber {
    private final RepositoryTypeRegistry repositoryTypeRegistry;
    private final TargetRegistry targetRegistry;
    private final ApplicationConfiguration applicationConfiguration;

    @Inject
    public DefaultTargetRegistryEventInspector(RepositoryTypeRegistry repositoryTypeRegistry, TargetRegistry targetRegistry, ApplicationConfiguration applicationConfiguration) {
        this.repositoryTypeRegistry = repositoryTypeRegistry;
        this.targetRegistry = targetRegistry;
        this.applicationConfiguration = applicationConfiguration;
    }

    @Subscribe
    public void inspect(NexusStartedEvent evt) {
        try {
            boolean changed = false;
            Map<String, ContentClass> contentClasses = this.repositoryTypeRegistry.getContentClasses();
            for (String key : contentClasses.keySet()) {
                boolean found = false;
                for (Target target : this.targetRegistry.getTargetsForContentClass(contentClasses.get(key))) {
                    if (!target.getContentClass().equals(contentClasses.get(key)) || target.getPatternTexts().size() != 1 || !target.getPatternTexts().iterator().next().equals(".*")) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Target newTarget = new Target(key, "All (" + key + ")", contentClasses.get(key), Collections.singleton(".*"));
                this.targetRegistry.addRepositoryTarget(newTarget);
                changed = true;
                this.log.info("Adding default target for {} content class", (Object)key);
            }
            if (changed) {
                this.applicationConfiguration.saveConfiguration();
            }
        }
        catch (IOException e) {
            this.log.error("Unable to properly add default Repository Targets", (Throwable)e);
        }
        catch (ConfigurationException e) {
            this.log.error("Unable to properly add default Repository Targets", (Throwable)e);
        }
    }
}

