/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.targets;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryTarget;
import org.sonatype.nexus.configuration.model.CRepositoryTargetCoreConfiguration;
import org.sonatype.nexus.configuration.validator.ApplicationConfigurationValidator;
import org.sonatype.nexus.proxy.events.TargetRegistryEventAdd;
import org.sonatype.nexus.proxy.events.TargetRegistryEventRemove;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.proxy.targets.TargetMatch;
import org.sonatype.nexus.proxy.targets.TargetRegistry;
import org.sonatype.nexus.proxy.targets.TargetSet;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultTargetRegistry
extends AbstractLastingConfigurable<List<CRepositoryTarget>>
implements TargetRegistry {
    private final RepositoryTypeRegistry repositoryTypeRegistry;
    private final ApplicationConfigurationValidator validator;
    private Map<String, Target> targets;

    @Inject
    public DefaultTargetRegistry(EventBus eventBus, ApplicationConfiguration applicationConfiguration, RepositoryTypeRegistry repositoryTypeRegistry, ApplicationConfigurationValidator validator) {
        super("Repository Target Registry", eventBus, applicationConfiguration);
        this.repositoryTypeRegistry = (RepositoryTypeRegistry)Preconditions.checkNotNull((Object)repositoryTypeRegistry);
        this.validator = (ApplicationConfigurationValidator)Preconditions.checkNotNull((Object)validator);
    }

    @Override
    protected void initializeConfiguration() throws ConfigurationException {
        if (this.getApplicationConfiguration().getConfigurationModel() != null) {
            this.configure(this.getApplicationConfiguration());
        }
    }

    @Override
    protected CoreConfiguration<List<CRepositoryTarget>> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CRepositoryTargetCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    @Override
    protected void doConfigure() throws ConfigurationException {
        super.doConfigure();
        this.rebuildView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildView() {
        CoreConfiguration coreConfiguration = this.getCurrentCoreConfiguration();
        synchronized (coreConfiguration) {
            List ctargets = (List)this.getCurrentConfiguration(false);
            HashMap<String, Target> newView = new HashMap<String, Target>(ctargets.size());
            for (CRepositoryTarget ctarget : ctargets) {
                Target target = this.convert(ctarget);
                if (target == null) continue;
                newView.put(target.getId(), target);
            }
            this.targets = newView;
        }
    }

    protected Target convert(CRepositoryTarget target) {
        ContentClass contentClass = this.getContentClassById(target.getContentClass());
        if (contentClass != null) {
            return new Target(target.getId(), target.getName(), contentClass, target.getPatterns());
        }
        return null;
    }

    protected CRepositoryTarget convert(Target target) {
        CRepositoryTarget result = new CRepositoryTarget();
        result.setId(target.getId());
        result.setName(target.getName());
        result.setContentClass(target.getContentClass().getId());
        ArrayList<String> patterns = new ArrayList<String>(target.getPatternTexts().size());
        patterns.addAll(target.getPatternTexts());
        result.setPatterns(patterns);
        return result;
    }

    protected void validate(CRepositoryTarget target) throws InvalidConfigurationException {
        ValidationResponse response = this.validator.validateRepositoryTarget(null, target);
        if (!response.isValid()) {
            throw new InvalidConfigurationException(response);
        }
    }

    protected ContentClass getContentClassById(String id) {
        return this.repositoryTypeRegistry.getContentClasses().get(id);
    }

    @Override
    public Collection<Target> getRepositoryTargets() {
        return Collections.unmodifiableCollection(this.targets.values());
    }

    @Override
    public Target getRepositoryTarget(String id) {
        return this.targets.get(id);
    }

    @Override
    public synchronized boolean addRepositoryTarget(Target target) throws ConfigurationException {
        CRepositoryTarget cnf = this.convert(target);
        this.validate(cnf);
        this.removeRepositoryTarget(cnf.getId(), true);
        ((List)this.getCurrentConfiguration(true)).add(cnf);
        this.eventBus().post((Object)new TargetRegistryEventAdd(this, target));
        return true;
    }

    @Override
    public synchronized boolean removeRepositoryTarget(String id) {
        return this.removeRepositoryTarget(id, false);
    }

    protected boolean removeRepositoryTarget(String id, boolean forUpdate) {
        List targets = (List)this.getCurrentConfiguration(true);
        Iterator ti = targets.iterator();
        while (ti.hasNext()) {
            CRepositoryTarget cTarget = (CRepositoryTarget)ti.next();
            if (!StringUtils.equals((String)id, (String)cTarget.getId())) continue;
            Target target = this.getRepositoryTarget(id);
            ti.remove();
            if (!forUpdate) {
                this.eventBus().post((Object)new TargetRegistryEventRemove(this, target));
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<Target> getTargetsForContentClass(ContentClass contentClass) {
        this.log.debug("Resolving targets for contentClass='{}'", (Object)contentClass.getId());
        HashSet<Target> result = new HashSet<Target>();
        for (Target t : this.getRepositoryTargets()) {
            if (!t.getContentClass().equals(contentClass)) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public Set<Target> getTargetsForContentClassPath(ContentClass contentClass, String path) {
        this.log.debug("Resolving targets for contentClass='{}' for path='{}'", (Object)contentClass.getId(), (Object)path);
        HashSet<Target> result = new HashSet<Target>();
        for (Target t : this.getRepositoryTargets()) {
            if (!t.isPathContained(contentClass, path)) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public TargetSet getTargetsForRepositoryPath(Repository repository, String path) {
        this.log.debug("Resolving targets for repository='{}' for path='{}'", (Object)repository.getId(), (Object)path);
        TargetSet result = new TargetSet();
        for (Target t : this.getRepositoryTargets()) {
            if (!t.isPathContained(repository.getRepositoryContentClass(), path)) continue;
            result.addTargetMatch(new TargetMatch(t, repository));
        }
        return result;
    }

    @Override
    public boolean hasAnyApplicableTarget(Repository repository) {
        this.log.debug("Looking for any targets for repository='{}'", (Object)repository.getId());
        for (Target t : this.getRepositoryTargets()) {
            if (!t.getContentClass().isCompatible(repository.getRepositoryContentClass())) continue;
            return true;
        }
        return false;
    }
}

