/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.remote.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.sonatype.nexus.util.WrappingInputStream;

class InterruptableInputStream
extends WrappingInputStream {
    private AbortableHttpRequest request;

    public InterruptableInputStream(AbortableHttpRequest request, InputStream stream) {
        super(stream);
        this.request = request;
    }

    public InterruptableInputStream(InputStream stream) {
        this(null, stream);
    }

    private void abortIfInterrupted() throws IOException {
        if (Thread.interrupted()) {
            if (this.request != null) {
                this.request.abort();
            }
            throw new InterruptedIOException();
        }
    }

    @Override
    public int read() throws IOException {
        this.abortIfInterrupted();
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.abortIfInterrupted();
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.abortIfInterrupted();
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.abortIfInterrupted();
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.abortIfInterrupted();
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abortIfInterrupted();
        super.reset();
    }
}

