/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.remote.httpclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.RemoteAccessDeniedException;
import org.sonatype.nexus.proxy.RemoteAuthenticationNeededException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.RemoteStorageTransportOverloadedException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.remote.AbstractHTTPRemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.DefaultRemoteStorageContext;
import org.sonatype.nexus.proxy.storage.remote.RemoteItemNotFoundException;
import org.sonatype.nexus.proxy.storage.remote.RemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.storage.remote.http.QueryStringBuilder;
import org.sonatype.nexus.proxy.storage.remote.httpclient.Hc4InputStream;
import org.sonatype.nexus.proxy.storage.remote.httpclient.HttpClientManager;
import org.sonatype.nexus.proxy.storage.remote.httpclient.InterruptableInputStream;

@Named(value="apacheHttpClient4x")
@Singleton
public class HttpClientRemoteStorage
extends AbstractHTTPRemoteRepositoryStorage
implements RemoteRepositoryStorage {
    static final Logger outboundRequestLog = LoggerFactory.getLogger((String)"remote.storage.outbound");
    public static final String PROVIDER_STRING = "apacheHttpClient4x";
    public static final String NEXUS_MISSING_ARTIFACT_HEADER = "x-nexus-missing-artifact";
    private static final String CTX_KEY_CLIENT = "apacheHttpClient4x.client";
    private static final String CTX_KEY_S3_FLAG = "apacheHttpClient4x.remoteIsAmazonS3";
    private static final boolean CAN_READ = true;
    private static final boolean CAN_WRITE = true;
    private final MetricsRegistry metricsRegistry = Metrics.defaultRegistry();
    private final QueryStringBuilder queryStringBuilder;
    private final HttpClientManager httpClientManager;
    public static final String CONTENT_RETRIEVAL_MARKER_KEY = HttpClientRemoteStorage.class.getName() + "#retrieveItem";

    @Inject
    HttpClientRemoteStorage(ApplicationStatusSource applicationStatusSource, MimeSupport mimeSupport, QueryStringBuilder queryStringBuilder, HttpClientManager httpClientManager) {
        super(applicationStatusSource, mimeSupport);
        this.queryStringBuilder = queryStringBuilder;
        this.httpClientManager = httpClientManager;
    }

    @Override
    public String getProviderId() {
        return PROVIDER_STRING;
    }

    private void validatePath(ProxyRepository repository, ResourceStoreRequest request) throws ItemNotFoundException {
        try {
            URI.create(request.getRequestPath());
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Remote HTTP request with malformed path attempted: repository {}, path {}", (Object)repository, (Object)request.getRequestPath());
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, repository, "Malformed HTTP request path '{}'", request.getRequestPath()), (Throwable)e);
        }
    }

    @Override
    public AbstractStorageItem retrieveItem(ProxyRepository repository, ResourceStoreRequest request, String baseUrl) throws ItemNotFoundException, RemoteStorageException {
        this.validatePath(repository, request);
        URL remoteURL = this.appendQueryString(repository, request, this.getAbsoluteUrlFromBase(baseUrl, request.getRequestPath()));
        String url = remoteURL.toExternalForm();
        if (remoteURL.getPath().endsWith("/")) {
            throw new RemoteItemNotFoundException(request, repository, "remoteIsCollection", remoteURL.toString());
        }
        HttpGet method = new HttpGet(url);
        HttpResponse httpResponse = this.executeRequest(repository, request, (HttpUriRequest)method, baseUrl, true);
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            try {
                long entityLength;
                Hc4InputStream is = new Hc4InputStream(repository, new InterruptableInputStream((AbortableHttpRequest)method, httpResponse.getEntity().getContent()));
                String mimeType = null;
                try {
                    mimeType = ContentType.getOrDefault((HttpEntity)httpResponse.getEntity()).getMimeType();
                }
                catch (UnsupportedCharsetException | ParseException throwable) {
                    // empty catch block
                }
                if (mimeType == null) {
                    mimeType = this.getMimeSupport().guessMimeTypeFromPath(repository.getMimeRulesSource(), request.getRequestPath());
                }
                DefaultStorageFileItem httpItem = new DefaultStorageFileItem(repository, request, true, true, (ContentLocator)new PreparedContentLocator(is, mimeType, (entityLength = httpResponse.getEntity().getContentLength()) != -1L ? entityLength : -1L));
                httpItem.setRemoteUrl(remoteURL.toString());
                httpItem.setModified(this.makeDateFromHeader(httpResponse.getFirstHeader("last-modified")));
                httpItem.setCreated(httpItem.getModified());
                return httpItem;
            }
            catch (IOException ex) {
                this.release(httpResponse);
                throw new RemoteStorageException("IO Error during response stream handling [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + remoteURL.toString() + "\"]!", ex);
            }
            catch (RuntimeException ex) {
                this.release(httpResponse);
                throw ex;
            }
        }
        this.release(httpResponse);
        if (httpResponse.getStatusLine().getStatusCode() == 404) {
            throw new RemoteItemNotFoundException(request, repository, "NotFound", remoteURL.toString());
        }
        if (httpResponse.getStatusLine().getStatusCode() == 302 || httpResponse.getStatusLine().getStatusCode() == 301) {
            throw new RemoteItemNotFoundException(request, repository, "redirected", remoteURL.toString());
        }
        throw new RemoteStorageException("The method execution returned result code " + httpResponse.getStatusLine().getStatusCode() + " (expected 200). [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + remoteURL.toString() + "\"]");
    }

    @Override
    public void storeItem(ProxyRepository repository, StorageItem item) throws UnsupportedStorageOperationException, RemoteStorageException {
        InputStreamEntity entity;
        if (!(item instanceof StorageFileItem)) {
            throw new UnsupportedStorageOperationException("Storing of non-files remotely is not supported!");
        }
        StorageFileItem fileItem = (StorageFileItem)item;
        ResourceStoreRequest request = new ResourceStoreRequest(item);
        try {
            this.validatePath(repository, request);
        }
        catch (ItemNotFoundException e) {
            throw new RemoteStorageException("Invalid path to store", e);
        }
        URL remoteUrl = this.appendQueryString(repository, request, this.getAbsoluteUrlFromBase(repository, request));
        HttpPut method = new HttpPut(remoteUrl.toExternalForm());
        try {
            entity = new InputStreamEntity((InputStream)new InterruptableInputStream(fileItem.getInputStream()), fileItem.getLength());
        }
        catch (IOException e) {
            throw new RemoteStorageException(e.getMessage() + " [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + remoteUrl.toString() + "\"]", e);
        }
        entity.setContentType(fileItem.getMimeType());
        method.setEntity((HttpEntity)entity);
        HttpResponse httpResponse = this.executeRequestAndRelease(repository, request, (HttpUriRequest)method, repository.getRemoteUrl());
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 201 && statusCode != 204 && statusCode != 202) {
            throw new RemoteStorageException("Unexpected response code while executing " + method.getMethod() + " method [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + remoteUrl.toString() + "\"]. Expected: \"any success (2xx)\". Received: " + statusCode + " : " + httpResponse.getStatusLine().getReasonPhrase());
        }
    }

    @Override
    public void deleteItem(ProxyRepository repository, ResourceStoreRequest request) throws ItemNotFoundException, UnsupportedStorageOperationException, RemoteStorageException {
        this.validatePath(repository, request);
        URL remoteUrl = this.appendQueryString(repository, request, this.getAbsoluteUrlFromBase(repository, request));
        HttpDelete method = new HttpDelete(remoteUrl.toExternalForm());
        HttpResponse httpResponse = this.executeRequestAndRelease(repository, request, (HttpUriRequest)method, repository.getRemoteUrl());
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 204 && statusCode != 202) {
            throw new RemoteStorageException("The response to HTTP " + method.getMethod() + " was unexpected HTTP Code " + statusCode + " : " + httpResponse.getStatusLine().getReasonPhrase() + " [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + remoteUrl.toString() + "\"]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkRemoteAvailability(long newerThen, ProxyRepository repository, ResourceStoreRequest request, boolean isStrict) throws RemoteStorageException {
        try {
            this.validatePath(repository, request);
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        URL remoteUrl = this.appendQueryString(repository, request, this.getAbsoluteUrlFromBase(repository, request));
        HttpResponse httpResponse = null;
        int statusCode = 400;
        boolean doGet = false;
        HttpHead method = new HttpHead(remoteUrl.toExternalForm());
        try {
            httpResponse = this.executeRequestAndRelease(repository, request, (HttpUriRequest)method, repository.getRemoteUrl());
            statusCode = httpResponse.getStatusLine().getStatusCode();
        }
        catch (RemoteStorageException e) {
            doGet = true;
            this.log.debug("HEAD method failed, will attempt GET. Exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (!doGet && statusCode != 200) {
                doGet = true;
                this.log.debug("HEAD method failed, will attempt GET. Status: " + statusCode);
            }
        }
        if (doGet) {
            method = new HttpGet(remoteUrl.toExternalForm());
            httpResponse = this.executeRequestAndRelease(repository, request, (HttpUriRequest)method, repository.getRemoteUrl());
            statusCode = httpResponse.getStatusLine().getStatusCode();
        }
        if (!isStrict && this.isRemotePeerAmazonS3Storage(repository)) {
            return statusCode >= 200 && statusCode <= 500;
        }
        if (statusCode == 200) {
            if (newerThen > 0L) {
                return this.makeDateFromHeader(httpResponse.getFirstHeader("last-modified")) > newerThen;
            }
            return true;
        }
        if (statusCode >= 300 && statusCode < 400 || statusCode == 404) {
            if ("/".equals(request.getRequestPath()) && statusCode == 404) {
                RemoteStorageContext ctx = this.getRemoteStorageContext(repository);
                HttpClient httpClient = (HttpClient)ctx.getContextObject(CTX_KEY_CLIENT);
                Page.RepositoryPageContext pageContext = new Page.RepositoryPageContext(httpClient, repository);
                ResourceStoreRequest rmRequest = new ResourceStoreRequest("/.meta/repository-metadata.xml");
                URL nxRepoMetadataUrl = this.appendQueryString(repository, rmRequest, this.getAbsoluteUrlFromBase(repository, rmRequest));
                try {
                    Page page = Page.getPageFor(pageContext, nxRepoMetadataUrl.toExternalForm());
                    if (page.getStatusCode() == 200) {
                        this.log.debug("Original GET request for URL {} failed with 404, but GET request for URL {} succeeded, we assume remote is a Nexus repository having browsing disabled.", (Object)remoteUrl, (Object)nxRepoMetadataUrl);
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        throw new RemoteStorageException("Unexpected response code while executing " + method.getMethod() + " method [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + remoteUrl.toString() + "\"]. Expected: \"SUCCESS (200)\". Received: " + statusCode + " : " + httpResponse.getStatusLine().getReasonPhrase());
    }

    @Override
    protected void updateContext(ProxyRepository repository, RemoteStorageContext ctx) throws RemoteStorageException {
        ctx.removeContextObject(CTX_KEY_CLIENT);
        ctx.removeContextObject(CTX_KEY_S3_FLAG);
        this.httpClientManager.release(repository, ctx);
        try {
            HttpClient httpClient = this.httpClientManager.create(repository, ctx);
            ctx.putContextObject(CTX_KEY_CLIENT, httpClient);
            ctx.putContextObject(CTX_KEY_S3_FLAG, new DefaultRemoteStorageContext.BooleanFlagHolder());
        }
        catch (IllegalStateException e) {
            throw new RemoteStorageException("Could not create HTTPClient4x instance!", e);
        }
    }

    @Override
    protected String getS3FlagKey() {
        return CTX_KEY_S3_FLAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    HttpResponse executeRequest(ProxyRepository repository, ResourceStoreRequest request, HttpUriRequest httpRequest, String baseUrl, boolean contentRequest) throws RemoteStorageException {
        Timer timer = this.timer(repository, httpRequest, baseUrl);
        TimerContext timerContext = timer.time();
        Stopwatch stopwatch = null;
        if (outboundRequestLog.isDebugEnabled()) {
            outboundRequestLog.debug("[{}] {} {}", new Object[]{repository.getId(), httpRequest.getMethod(), httpRequest.getURI()});
            stopwatch = Stopwatch.createStarted();
        }
        HttpResponse response = null;
        try {
            response = this.doExecuteRequest(repository, request, httpRequest, contentRequest);
        }
        catch (Throwable throwable) {
            timerContext.stop();
            if (stopwatch != null) {
                outboundRequestLog.debug("[{}] {} {} -> {}; {}", new Object[]{repository.getId(), httpRequest.getMethod(), httpRequest.getURI(), response != null ? response.getStatusLine() : "null", stopwatch});
            }
            throw throwable;
        }
        timerContext.stop();
        if (stopwatch != null) {
            outboundRequestLog.debug("[{}] {} {} -> {}; {}", new Object[]{repository.getId(), httpRequest.getMethod(), httpRequest.getURI(), response != null ? response.getStatusLine() : "null", stopwatch});
        }
        return response;
    }

    private Timer timer(ProxyRepository repository, HttpUriRequest httpRequest, String baseUrl) {
        return this.metricsRegistry.newTimer(HttpClientRemoteStorage.class, baseUrl, httpRequest.getMethod());
    }

    private HttpResponse doExecuteRequest(ProxyRepository repository, ResourceStoreRequest request, HttpUriRequest httpRequest, boolean contentRequest) throws RemoteStorageException {
        URI methodUri = httpRequest.getURI();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Invoking HTTP {} method against remote location {}", (Object)httpRequest.getMethod(), (Object)methodUri);
        }
        RemoteStorageContext ctx = this.getRemoteStorageContext(repository);
        HttpClient httpClient = (HttpClient)ctx.getContextObject(CTX_KEY_CLIENT);
        httpRequest.setHeader("Accept", "*/*");
        httpRequest.setHeader("Accept-Language", "en-us");
        httpRequest.setHeader("Accept-Encoding", "gzip,deflate,identity");
        httpRequest.setHeader("Cache-Control", "no-cache");
        HttpResponse httpResponse = null;
        try {
            boolean proxyReturnedError;
            BasicHttpContext httpContext = new BasicHttpContext();
            httpContext.setAttribute(Hc4Provider.HTTP_CTX_KEY_REPOSITORY, (Object)repository);
            if (contentRequest) {
                httpContext.setAttribute(CONTENT_RETRIEVAL_MARKER_KEY, (Object)Boolean.TRUE);
            }
            httpResponse = httpClient.execute(httpRequest, (HttpContext)httpContext);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            Header httpServerHeader = httpResponse.getFirstHeader("server");
            this.checkForRemotePeerAmazonS3Storage(repository, httpServerHeader == null ? null : httpServerHeader.getValue());
            Header proxyReturnedErrorHeader = httpResponse.getFirstHeader(NEXUS_MISSING_ARTIFACT_HEADER);
            boolean bl = proxyReturnedError = proxyReturnedErrorHeader != null && Boolean.valueOf(proxyReturnedErrorHeader.getValue()) != false;
            if (statusCode == 403) {
                throw new RemoteAccessDeniedException(repository, methodUri.toASCIIString(), httpResponse.getStatusLine().getReasonPhrase());
            }
            if (statusCode == 401) {
                throw new RemoteAuthenticationNeededException(repository, httpResponse.getStatusLine().getReasonPhrase());
            }
            if (statusCode == 200 && proxyReturnedError) {
                throw new RemoteStorageException("Invalid artifact found, most likely a proxy redirected to an HTML error page.");
            }
            return httpResponse;
        }
        catch (RemoteStorageException ex) {
            this.release(httpResponse);
            throw ex;
        }
        catch (ClientProtocolException ex) {
            this.release(httpResponse);
            throw new RemoteStorageException("Protocol error while executing " + httpRequest.getMethod() + " method. [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + methodUri.toASCIIString() + "\"]", ex);
        }
        catch (ConnectionPoolTimeoutException ex) {
            this.release(httpResponse);
            throw new RemoteStorageTransportOverloadedException(repository, "Connection pool timeout error while executing " + httpRequest.getMethod() + " method [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + methodUri.toASCIIString() + "\"]", ex);
        }
        catch (IOException ex) {
            this.release(httpResponse);
            throw new RemoteStorageException("Transport error while executing " + httpRequest.getMethod() + " method [repositoryId=\"" + repository.getId() + "\", requestPath=\"" + request.getRequestPath() + "\", remoteUrl=\"" + methodUri.toASCIIString() + "\"]", ex);
        }
    }

    private HttpResponse executeRequestAndRelease(ProxyRepository repository, ResourceStoreRequest request, HttpUriRequest httpRequest, String baseUrl) throws RemoteStorageException {
        HttpResponse httpResponse = this.executeRequest(repository, request, httpRequest, baseUrl, false);
        this.release(httpResponse);
        return httpResponse;
    }

    private long makeDateFromHeader(Header date) {
        long result = System.currentTimeMillis();
        if (date != null) {
            try {
                result = DateUtils.parseDate((String)date.getValue()).getTime();
            }
            catch (Exception ex) {
                this.log.warn("Could not parse date '{}', using system current time as item creation time.", (Object)date, (Object)ex);
            }
        }
        return result;
    }

    private URL appendQueryString(ProxyRepository repository, ResourceStoreRequest request, URL url) throws RemoteStorageException {
        RemoteStorageContext ctx = this.getRemoteStorageContext(repository);
        String queryString = this.queryStringBuilder.getQueryString(ctx, repository);
        if (StringUtils.isNotBlank((String)queryString)) {
            try {
                if (StringUtils.isBlank((String)url.getQuery())) {
                    return new URL(url.toExternalForm() + "?" + queryString);
                }
                return new URL(url.toExternalForm() + "&" + queryString);
            }
            catch (MalformedURLException e) {
                throw new RemoteStorageException("Could not append query string \"" + queryString + "\" to url \"" + url + "\"", e);
            }
        }
        return url;
    }

    private void release(HttpResponse httpResponse) {
        if (httpResponse != null) {
            try {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            }
            catch (IOException e) {
                this.log.warn("Failed to consume entity: " + e);
            }
        }
    }
}

