/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.remote.httpclient;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.storage.remote.httpclient.HttpClientManager;
import org.sonatype.nexus.proxy.storage.remote.httpclient.HttpClientRemoteStorage;
import org.sonatype.nexus.proxy.utils.UserAgentBuilder;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class HttpClientManagerImpl
extends ComponentSupport
implements HttpClientManager {
    private static final String NX_REMOTE_ENABLE_CIRCULAR_REDIRECTS_KEY = "nexus.remoteStorage.enableCircularRedirectsForHosts";
    private static final String NX_REMOTE_USE_COOKIES_KEY = "nexus.remoteStorage.useCookiesForHosts";
    private final Hc4Provider hc4Provider;
    private final UserAgentBuilder userAgentBuilder;
    private final Set<String> enableCircularRedirectsForHosts;
    private final Set<String> useCookiesForHosts;

    @Inject
    public HttpClientManagerImpl(Hc4Provider hc4Provider, UserAgentBuilder userAgentBuilder) {
        this.hc4Provider = (Hc4Provider)Preconditions.checkNotNull((Object)hc4Provider);
        this.userAgentBuilder = (UserAgentBuilder)Preconditions.checkNotNull((Object)userAgentBuilder);
        this.enableCircularRedirectsForHosts = this.parseAndNormalizeCsvProperty(NX_REMOTE_ENABLE_CIRCULAR_REDIRECTS_KEY);
        this.useCookiesForHosts = this.parseAndNormalizeCsvProperty(NX_REMOTE_USE_COOKIES_KEY);
    }

    @Override
    public HttpClient create(ProxyRepository proxyRepository, RemoteStorageContext ctx) {
        Preconditions.checkNotNull((Object)proxyRepository);
        Preconditions.checkNotNull((Object)ctx);
        Hc4Provider.Builder builder = this.hc4Provider.prepareHttpClient(ctx);
        this.configure(proxyRepository, ctx, builder);
        return builder.build();
    }

    @Override
    public void release(ProxyRepository proxyRepository, RemoteStorageContext ctx) {
    }

    private String normalizeHostname(ProxyRepository proxyRepository) {
        try {
            URI uri = new URI(proxyRepository.getRemoteUrl());
            return this.normalizeHostname(uri.getHost());
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }

    private String normalizeHostname(String hostName) {
        if (hostName == null) {
            return "";
        }
        return hostName.toLowerCase(Locale.US).trim();
    }

    private Set<String> parseAndNormalizeCsvProperty(String systemPropertyKey) {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)SystemPropertiesHelper.getString(systemPropertyKey, "")), (Function)new Function<String, String>(){

            public String apply(String input) {
                return HttpClientManagerImpl.this.normalizeHostname(input);
            }
        }));
    }

    protected void configure(ProxyRepository proxyRepository, RemoteStorageContext ctx, Hc4Provider.Builder builder) {
        builder.getHttpClientBuilder().setUserAgent(this.userAgentBuilder.formatRemoteRepositoryStorageUserAgentString(proxyRepository, ctx));
        builder.getHttpClientBuilder().setRedirectStrategy(this.getProxyRepositoryRedirectStrategy(proxyRepository, ctx));
        String proxyHostName = this.normalizeHostname(proxyRepository);
        if (this.enableCircularRedirectsForHosts.contains(proxyHostName)) {
            this.log.info("Allowing circular redirects in proxy {}", (Object)proxyRepository);
            builder.getRequestConfigBuilder().setCircularRedirectsAllowed(true);
            builder.getRequestConfigBuilder().setMaxRedirects(10);
        }
        if (this.useCookiesForHosts.contains(proxyHostName)) {
            this.log.info("Allowing cookie use in proxy {}", (Object)proxyRepository);
            builder.getHttpClientBuilder().setDefaultCookieStore((CookieStore)new BasicCookieStore());
            builder.getRequestConfigBuilder().setCookieSpec("compatibility");
        }
    }

    protected RedirectStrategy getProxyRepositoryRedirectStrategy(final ProxyRepository proxyRepository, RemoteStorageContext ctx) {
        return new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                Logger logger = HttpClientRemoteStorage.outboundRequestLog;
                if (super.isRedirected(request, response, context)) {
                    Header locationHeader = response.getFirstHeader("location");
                    if (locationHeader == null) {
                        throw new ProtocolException("Received redirect response " + response.getStatusLine() + " from proxy " + proxyRepository + " but no location present");
                    }
                    boolean redirecting = true;
                    URI targetUri = this.createLocationURI(locationHeader.getValue());
                    if (Boolean.TRUE == context.getAttribute(HttpClientRemoteStorage.CONTENT_RETRIEVAL_MARKER_KEY) && targetUri.getPath().endsWith("/")) {
                        redirecting = false;
                    }
                    if (logger.isDebugEnabled()) {
                        String repoId = proxyRepository.getId();
                        URI sourceUri = ((HttpUriRequest)request).getURI();
                        if (!sourceUri.isAbsolute()) {
                            try {
                                sourceUri = URI.create(proxyRepository.getRemoteUrl()).resolve(sourceUri);
                            }
                            catch (Exception e) {
                                logger.debug("[{}] Problem resolving {} against {}", new Object[]{repoId, sourceUri, proxyRepository.getRemoteUrl()});
                            }
                        }
                        String sourceScheme = HttpClientManagerImpl.schemeOf(sourceUri);
                        String sourceHost = HttpClientManagerImpl.hostOf(sourceUri);
                        String targetScheme = HttpClientManagerImpl.schemeOf(targetUri);
                        String targetHost = HttpClientManagerImpl.hostOf(targetUri);
                        int redirectCode = response.getStatusLine().getStatusCode();
                        if (!Objects.equals(sourceScheme, targetScheme)) {
                            if ("http".equals(targetScheme)) {
                                logger.debug("[{}] Downgrade from HTTPS to HTTP during {} redirect {} -> {}", new Object[]{repoId, redirectCode, sourceUri, targetUri});
                            } else if ("https".equals(targetScheme) && Objects.equals(sourceHost, targetHost)) {
                                logger.debug("[{}] Protocol upgrade during {} redirect on same host {} -> {}", new Object[]{repoId, redirectCode, sourceUri, targetUri});
                            }
                        }
                        if (redirecting) {
                            logger.debug("[{}] Following {} redirect {} -> {}", new Object[]{repoId, redirectCode, sourceUri, targetUri});
                        } else {
                            logger.debug("[{}] Not following {} redirect {} -> {}", new Object[]{repoId, redirectCode, sourceUri, targetUri});
                        }
                    }
                    return redirecting;
                }
                return false;
            }
        };
    }

    @Nullable
    private static String schemeOf(URI uri) {
        String scheme;
        if (uri != null && (scheme = uri.getScheme()) != null) {
            return scheme.toLowerCase(Locale.US);
        }
        return null;
    }

    @Nullable
    private static String hostOf(URI uri) {
        if (uri != null) {
            return uri.getHost();
        }
        return null;
    }
}

