/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.remote.http;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.storage.remote.http.QueryStringContributor;

@Named
@Singleton
public class QueryStringBuilder {
    private final List<QueryStringContributor> queryParameterContributors;

    @Inject
    public QueryStringBuilder(List<QueryStringContributor> queryParameterContributors) {
        this.queryParameterContributors = (List)Preconditions.checkNotNull(queryParameterContributors);
    }

    public String getQueryString(RemoteStorageContext ctx, ProxyRepository repository) {
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkNotNull((Object)repository);
        StringBuilder result = new StringBuilder();
        String configuredQueryString = ctx.getRemoteConnectionSettings().getQueryString();
        if (StringUtils.isNotBlank((String)configuredQueryString)) {
            result.append(configuredQueryString);
        }
        for (QueryStringContributor contributor : this.queryParameterContributors) {
            String contributedQueryString = contributor.getQueryString(ctx, repository);
            if (!StringUtils.isNotBlank((String)contributedQueryString)) continue;
            if (StringUtils.isNotBlank((String)result.toString())) {
                result.append('&');
            }
            result.append(contributedQueryString);
        }
        String resultStr = result.toString();
        return StringUtils.isNotBlank((String)resultStr) ? resultStr : null;
    }

    public String getQueryString(ProxyRepository repository) {
        Preconditions.checkNotNull((Object)repository);
        return this.getQueryString(repository.getRemoteStorageContext(), repository);
    }
}

