/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.remote;

import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.storage.remote.RemoteProviderHintFactory;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultRemoteProviderHintFactory
extends ComponentSupport
implements RemoteProviderHintFactory {
    public static final String DEFAULT_HTTP_PROVIDER_KEY = "nexus.default.http.provider";
    public static final String DEFAULT_HTTP_PROVIDER_FORCED_KEY = "nexus.default.http.providerForced";
    private Boolean httpProviderForced = null;

    protected synchronized boolean isHttpProviderForced() {
        if (this.httpProviderForced == null) {
            this.httpProviderForced = SystemPropertiesHelper.getBoolean(DEFAULT_HTTP_PROVIDER_FORCED_KEY, false);
            if (this.httpProviderForced.booleanValue()) {
                this.log.warn("HTTP Provider forcing is in effect (system property \"nexus.default.http.providerForced\" is set to \"true\"!), so regardless of your configuration, for HTTP RemoteRepositoryStorage the \"" + this.getDefaultHttpRoleHint() + "\" provider will be used! Consider adjusting your configuration instead and stop using provider forcing.");
            }
        }
        return this.httpProviderForced;
    }

    @Override
    public String getDefaultRoleHint(String remoteUrl) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)remoteUrl)) {
            throw new IllegalArgumentException("Remote URL cannot be null!");
        }
        String remoteUrlLowered = remoteUrl.toLowerCase();
        if (remoteUrlLowered.startsWith("http:") || remoteUrlLowered.startsWith("https:")) {
            return this.getDefaultHttpRoleHint();
        }
        throw new IllegalArgumentException("No known remote repository storage provider for remote URL " + remoteUrl);
    }

    @Override
    public String getRoleHint(String remoteUrl, String hint) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)remoteUrl)) {
            throw new IllegalArgumentException("Remote URL cannot be null!");
        }
        String remoteUrlLowered = remoteUrl.toLowerCase();
        if (remoteUrlLowered.startsWith("http:") || remoteUrlLowered.startsWith("https:")) {
            return this.getHttpRoleHint(hint);
        }
        if (StringUtils.isBlank((String)hint)) {
            throw new IllegalArgumentException("RemoteRepositoryStorage hint cannot be null!");
        }
        this.log.debug("Returning supplied \"{}\" hint for remote URL {}.", (Object)remoteUrl, (Object)hint);
        return hint;
    }

    @Override
    public String getDefaultHttpRoleHint() {
        return SystemPropertiesHelper.getString(DEFAULT_HTTP_PROVIDER_KEY, "apacheHttpClient4x");
    }

    @Override
    public String getHttpRoleHint(String hint) {
        if (this.isHttpProviderForced() || StringUtils.isBlank((String)hint)) {
            return this.getDefaultHttpRoleHint();
        }
        return hint;
    }
}

