/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.remote;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.AbstractContextualizedRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.RemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public abstract class AbstractRemoteRepositoryStorage
extends AbstractContextualizedRepositoryStorage<RemoteStorageContext>
implements RemoteRepositoryStorage {
    private final MimeSupport mimeSupport;
    private final ApplicationStatusSource applicationStatusSource;

    protected AbstractRemoteRepositoryStorage(ApplicationStatusSource applicationStatusSource, MimeSupport mimeSupport) {
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    protected MimeSupport getMimeSupport() {
        return this.mimeSupport;
    }

    @Override
    public URL getAbsoluteUrlFromBase(ProxyRepository repository, ResourceStoreRequest request) throws RemoteStorageException {
        return this.getAbsoluteUrlFromBase(repository.getRemoteUrl(), request.getRequestPath());
    }

    protected URL getAbsoluteUrlFromBase(String baseUrl, String path) throws RemoteStorageException {
        StringBuilder urlStr = new StringBuilder(baseUrl);
        if (!baseUrl.endsWith("/")) {
            urlStr.append("/");
        }
        if (!path.startsWith("/")) {
            urlStr.append(path);
        } else {
            urlStr.append(path.substring("/".length()));
        }
        try {
            return new URL(urlStr.toString());
        }
        catch (MalformedURLException e) {
            throw new RemoteStorageException("The repository has broken URL!", e);
        }
    }

    protected RemoteStorageContext getRemoteStorageContext(ProxyRepository repository) throws RemoteStorageException {
        try {
            return super.getStorageContext(repository, repository.getRemoteStorageContext());
        }
        catch (RemoteStorageException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RemoteStorageException("Could not update context of " + repository, e);
        }
    }

    @Override
    protected void updateStorageContext(Repository repository, RemoteStorageContext context, AbstractContextualizedRepositoryStorage.ContextOperation contextOperation) throws IOException {
        if (AbstractContextualizedRepositoryStorage.ContextOperation.INITIALIZE == contextOperation) {
            this.log.info("Initializing remote transport for proxy repository {}...", (Object)RepositoryStringUtils.getHumanizedNameString(repository));
        } else if (AbstractContextualizedRepositoryStorage.ContextOperation.UPDATE == contextOperation) {
            this.log.info("Updating remote transport for proxy repository {}...", (Object)RepositoryStringUtils.getHumanizedNameString(repository));
        }
        this.updateContext((ProxyRepository)repository, context);
    }

    @Override
    public boolean containsItem(ProxyRepository repository, ResourceStoreRequest request) throws RemoteStorageException {
        return this.containsItem(0L, repository, request);
    }

    @Override
    public String getVersion() {
        SystemStatus status = this.applicationStatusSource.getSystemStatus();
        return status.getVersion();
    }

    protected abstract void updateContext(ProxyRepository var1, RemoteStorageContext var2) throws RemoteStorageException;
}

