/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.remote;

import java.net.URI;
import java.net.URISyntaxException;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.RemoteAccessDeniedException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.remote.AbstractRemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.DefaultRemoteStorageContext;
import org.sonatype.nexus.proxy.storage.remote.RemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public abstract class AbstractHTTPRemoteRepositoryStorage
extends AbstractRemoteRepositoryStorage
implements RemoteRepositoryStorage {
    protected AbstractHTTPRemoteRepositoryStorage(ApplicationStatusSource applicationStatusSource, MimeSupport mimeSupport) {
        super(applicationStatusSource, mimeSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReachable(ProxyRepository repository, ResourceStoreRequest request) throws RemoteStorageException {
        request.pushRequestPath("/");
        try {
            boolean bl = this.checkRemoteAvailability(0L, repository, request, false);
            return bl;
        }
        catch (RemoteAccessDeniedException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            request.popRequestPath();
        }
    }

    @Override
    public void validateStorageUrl(String url) throws RemoteStorageException {
        try {
            URI u = new URI(url);
            if (!"http".equals(u.getScheme().toLowerCase()) && !"https".equals(u.getScheme().toLowerCase())) {
                throw new RemoteStorageException("Unsupported protocol, only HTTP/HTTPS protocols are supported: " + u.getScheme().toLowerCase());
            }
        }
        catch (URISyntaxException e) {
            throw new RemoteStorageException("Malformed URL", e);
        }
    }

    @Override
    public boolean containsItem(long newerThen, ProxyRepository repository, ResourceStoreRequest request) throws RemoteStorageException {
        return this.checkRemoteAvailability(newerThen, repository, request, true);
    }

    public boolean isRemotePeerAmazonS3Storage(ProxyRepository repository) throws RemoteStorageException {
        RemoteStorageContext ctx = this.getRemoteStorageContext(repository);
        return ctx.hasContextObject(this.getS3FlagKey()) && ((DefaultRemoteStorageContext.BooleanFlagHolder)ctx.getContextObject(this.getS3FlagKey())).isFlag();
    }

    protected void checkForRemotePeerAmazonS3Storage(ProxyRepository repository, String httpServerHeaderValue) throws RemoteStorageException {
        boolean isAmazonS3;
        RemoteStorageContext ctx = this.getRemoteStorageContext(repository);
        if (ctx.hasContextObject(this.getS3FlagKey()) && !((DefaultRemoteStorageContext.BooleanFlagHolder)ctx.getContextObject(this.getS3FlagKey())).isNull()) {
            return;
        }
        boolean bl = isAmazonS3 = httpServerHeaderValue != null && httpServerHeaderValue.toLowerCase().contains("amazons3");
        if (ctx.hasContextObject(this.getS3FlagKey())) {
            ((DefaultRemoteStorageContext.BooleanFlagHolder)ctx.getContextObject(this.getS3FlagKey())).setFlag(isAmazonS3);
        }
        if (isAmazonS3) {
            this.log.info("The proxy repository {} is backed by Amazon S3 service. This means that Nexus can't reliably detect the validity of your setup (baseUrl of proxy repository)!", (Object)RepositoryStringUtils.getHumanizedNameString(repository));
        }
    }

    protected abstract boolean checkRemoteAvailability(long var1, ProxyRepository var3, ResourceStoreRequest var4, boolean var5) throws RemoteStorageException;

    protected abstract String getS3FlagKey();
}

