/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.local.fs;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageEOFException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.RemoteStorageEOFException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsItemAttributeMetacontentAttribute;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.local.fs.FSPeer;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.nexus.util.io.StreamSupport;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.Throwables2;

@Named
@Singleton
public class DefaultFSPeer
extends ComponentSupport
implements FSPeer {
    private static final Predicate<Path> DOTTED_FILE_FILTER = new Predicate<Path>(){

        public boolean apply(Path input) {
            return input.getFileName().toString().startsWith(".");
        }
    };
    private static final String HIDDEN_TARGET_SUFFIX = ".nx-upload";
    private static final String APPENDIX = "nx-tmp";
    private static final String REPO_TMP_FOLDER = ".nexus/tmp";
    private static final String FILE_COPY_STREAM_BUFFER_SIZE_KEY = "upload.stream.bufferSize";
    private static final int FILE_COPY_STREAM_BUFFER_SIZE = SystemPropertiesHelper.getInteger("upload.stream.bufferSize", 8192);
    public static final String RENAME_RETRY_COUNT_KEY = "rename.retry.count";
    public static final int RENAME_RETRY_COUNT = SystemPropertiesHelper.getInteger("rename.retry.count", 0);
    public static final String RENAME_RETRY_DELAY_KEY = "rename.retry.delay";
    public static final long RENAME_RETRY_DELAY = SystemPropertiesHelper.getLong("rename.retry.delay", 0L);

    @Override
    public boolean isReachable(Repository repository, File repositoryBaseDir, ResourceStoreRequest request, File target) throws LocalStorageException {
        return target.exists() && target.canWrite();
    }

    @Override
    public boolean containsItem(Repository repository, File repositoryBaseDir, ResourceStoreRequest request, File target) throws LocalStorageException {
        return target.exists();
    }

    @Override
    public File retrieveItem(Repository repository, File repositoryBaseDir, ResourceStoreRequest request, File target) throws ItemNotFoundException, LocalStorageException {
        return target;
    }

    @Override
    public void storeItem(Repository repository, File repositoryBaseDir, StorageItem item, File target, ContentLocator cl) throws UnsupportedStorageOperationException, LocalStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Storing file to {}", (Object)target.getAbsolutePath());
        }
        this.mkDirs(repository, target.getParentFile());
        if (cl != null) {
            File hiddenTarget = this.getHiddenTarget(repository, repositoryBaseDir, target, item);
            try (InputStream is = cl.getContent();
                 BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(hiddenTarget), this.getCopyStreamBufferSize());){
                StreamSupport.copy(is, os, this.getCopyStreamBufferSize());
                ((OutputStream)os).flush();
            }
            catch (EOFException | RemoteStorageEOFException e) {
                try {
                    Files.deleteIfExists(hiddenTarget.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new LocalStorageEOFException(String.format("EOF during storing on path \"%s\" (while writing to hiddenTarget: \"%s\")", item.getRepositoryItemUid().toString(), hiddenTarget.getAbsolutePath()), e);
            }
            catch (IOException e) {
                try {
                    Files.deleteIfExists(hiddenTarget.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new LocalStorageException(String.format("Got exception during storing on path \"%s\" (while writing to hiddenTarget: \"%s\")", item.getRepositoryItemUid().toString(), hiddenTarget.getAbsolutePath()), e);
            }
            RepositoryItemUidLock uidLock = item.getRepositoryItemUid().getLock();
            uidLock.lock(Action.create);
            try {
                this.handleRenameOperation(hiddenTarget, target);
                target.setLastModified(item.getModified());
            }
            catch (IOException e) {
                boolean isCleanupNeeded;
                boolean bl = isCleanupNeeded = !item.getRepositoryItemUid().getBooleanAttributeValue(IsItemAttributeMetacontentAttribute.class);
                if (target != null && (isCleanupNeeded || target.length() == 0L)) {
                    try {
                        Files.delete(target.toPath());
                    }
                    catch (IOException e1) {
                        this.log.warn("Could not delete file: " + target.getAbsolutePath(), (Throwable)e);
                    }
                }
                if (hiddenTarget != null && (isCleanupNeeded || hiddenTarget.length() == 0L)) {
                    try {
                        Files.delete(hiddenTarget.toPath());
                    }
                    catch (IOException e1) {
                        this.log.warn("Could not delete file: " + target.getAbsolutePath(), (Throwable)e);
                    }
                }
                if (!isCleanupNeeded) {
                    this.log.warn("No cleanup done for error that happened while trying to save attibutes of item {}, the backup is left as {}!", (Object)item.getRepositoryItemUid().toString(), (Object)hiddenTarget.getAbsolutePath());
                }
                throw new LocalStorageException(String.format("Got exception during storing on path \"%s\" (while moving to final destination)", item.getRepositoryItemUid().toString()), e);
            }
            finally {
                uidLock.unlock();
            }
        }
        try {
            DirSupport.mkdir(target.toPath());
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        target.setLastModified(item.getModified());
    }

    @Override
    public void shredItem(Repository repository, File repositoryBaseDir, ResourceStoreRequest request, File target) throws ItemNotFoundException, UnsupportedStorageOperationException, LocalStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting file: {}", (Object)target.getAbsolutePath());
        }
        try {
            if (!DirSupport.deleteIfExists(target.toPath(), DOTTED_FILE_FILTER)) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, repository, "Path %s not found in local storage of repository %s", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(repository)));
            }
        }
        catch (IOException e) {
            throw new LocalStorageException(String.format("Could not delete file in repository %s from path \"%s\"", RepositoryStringUtils.getHumanizedNameString(repository), target.getAbsolutePath()), e);
        }
    }

    @Override
    public void moveItem(Repository repository, File repositoryBaseDir, ResourceStoreRequest from, File fromTarget, ResourceStoreRequest to, File toTarget) throws ItemNotFoundException, UnsupportedStorageOperationException, LocalStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Moving file from {} to {}", (Object)fromTarget.getAbsolutePath(), (Object)toTarget.getAbsolutePath());
        }
        try {
            if (!DirSupport.copyDeleteMoveIfExists(fromTarget.toPath(), toTarget.toPath(), DOTTED_FILE_FILTER)) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(from, repository, "Path %s not found in local storage of repository %s", from.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(repository)));
            }
        }
        catch (IOException e) {
            throw new LocalStorageException("Error during moveItem", e);
        }
    }

    @Override
    public Collection<File> listItems(Repository repository, File repositoryBaseDir, ResourceStoreRequest request, File target) throws ItemNotFoundException, LocalStorageException {
        if (target.isDirectory()) {
            ArrayList result = Lists.newArrayList();
            File[] files = target.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.getName().endsWith(DefaultFSPeer.HIDDEN_TARGET_SUFFIX);
                }
            });
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() && !file.isDirectory()) continue;
                    result.add(file);
                }
            } else {
                throw new LocalStorageException("Cannot list directory in repository " + repository + ", path " + target.getAbsolutePath());
            }
            return result;
        }
        if (target.isFile()) {
            return null;
        }
        throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, repository, "Path %s not found in local storage of repository %s", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(repository)));
    }

    protected File getHiddenTarget(Repository repository, File repositoryBaseDir, File target, StorageItem item) throws LocalStorageException {
        Preconditions.checkNotNull((Object)target);
        try {
            File repoTmpFolder = new File(repositoryBaseDir, REPO_TMP_FOLDER);
            this.mkDirs(repository, repoTmpFolder);
            return File.createTempFile(target.getName() + APPENDIX, HIDDEN_TARGET_SUFFIX, repoTmpFolder);
        }
        catch (IOException e) {
            throw new LocalStorageException(e.getMessage(), e);
        }
    }

    protected void mkDirs(Repository repository, File target) throws LocalStorageException {
        try {
            DirSupport.mkdir(target.toPath());
        }
        catch (IOException e) {
            throw new LocalStorageException(String.format("Could not create the directory hierarchy in repository %s to write \"%s\"", RepositoryStringUtils.getHumanizedNameString(repository), target.getAbsolutePath()), e);
        }
    }

    protected int getCopyStreamBufferSize() {
        return FILE_COPY_STREAM_BUFFER_SIZE;
    }

    protected void handleRenameOperation(File hiddenTarget, File target) throws IOException {
        if (RENAME_RETRY_COUNT == 0) {
            Files.move(hiddenTarget.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            ArrayList exceptions = Lists.newArrayListWithCapacity((int)(1 + RENAME_RETRY_COUNT));
            boolean success = false;
            for (int i = 1; i <= RENAME_RETRY_COUNT + 1; ++i) {
                try {
                    Files.move(hiddenTarget.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    success = true;
                    break;
                }
                catch (IOException e) {
                    exceptions.add(e);
                    try {
                        Thread.sleep(RENAME_RETRY_DELAY);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (!success) {
                throw (IOException)Throwables2.composite((Throwable)new IOException("Rename operation failed"), (Collection)exceptions);
            }
        }
    }
}

