/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.local.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ByteArrayContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageCollectionItem;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.DefaultStorageLinkItem;
import org.sonatype.nexus.proxy.item.FileContentLocator;
import org.sonatype.nexus.proxy.item.LinkPersister;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.item.uid.IsItemAttributeMetacontentAttribute;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.local.AbstractLocalRepositoryStorage;
import org.sonatype.nexus.proxy.storage.local.LocalStorageContext;
import org.sonatype.nexus.proxy.storage.local.fs.FSPeer;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.proxy.wastebasket.Wastebasket;
import org.sonatype.nexus.util.PathUtils;
import org.sonatype.nexus.util.file.DirSupport;

@Singleton
@Named(value="file")
public class DefaultFSLocalRepositoryStorage
extends AbstractLocalRepositoryStorage {
    public static final String PROVIDER_STRING = "file";
    @VisibleForTesting
    static final String BASEDIR_FILE = DefaultFSLocalRepositoryStorage.class.getName() + ".baseDir";
    private FSPeer fsPeer;
    private static Set<File> roots = null;

    @Inject
    public DefaultFSLocalRepositoryStorage(Wastebasket wastebasket, LinkPersister linkPersister, MimeSupport mimeSupport, FSPeer fsPeer) {
        super(wastebasket, linkPersister, mimeSupport);
        this.fsPeer = (FSPeer)Preconditions.checkNotNull((Object)fsPeer);
    }

    protected FSPeer getFSPeer() {
        return this.fsPeer;
    }

    @Override
    public String getProviderId() {
        return PROVIDER_STRING;
    }

    @Override
    public void validateStorageUrl(String url) throws LocalStorageException {
        boolean result = DefaultFSLocalRepositoryStorage.validFileUrl(url);
        if (!result) {
            throw new LocalStorageException("Invalid storage URL, not a file based one: " + url);
        }
    }

    @Override
    protected void updateContext(Repository repository, LocalStorageContext context) throws IOException {
        File file = DefaultFSLocalRepositoryStorage.getFileFromUrl(repository.getLocalUrl());
        DirSupport.mkdir(file.toPath());
        context.putContextObject(BASEDIR_FILE, file);
    }

    public File getBaseDir(Repository repository, ResourceStoreRequest request) throws LocalStorageException {
        return (File)this.getLocalStorageContext(repository).getContextObject(BASEDIR_FILE);
    }

    private File resolveFile(Repository repository, ResourceStoreRequest request) throws IOException {
        File baseDir = this.getBaseDir(repository, request);
        String requestPath = request.getRequestPath();
        File file = requestPath == null || "/".equals(requestPath) ? baseDir : (requestPath.startsWith("/") ? new File(baseDir, requestPath.substring(1)) : new File(baseDir, requestPath));
        Path basePath = baseDir.toPath().toAbsolutePath().normalize();
        Path filePath = file.toPath().toAbsolutePath().normalize();
        this.log.trace("Resolve request path '{}' to file: '{}'", (Object)requestPath, (Object)filePath);
        if (!filePath.startsWith(basePath)) {
            throw new LocalStorageException(String.format("Attempt to resolve repository '%s' (id='%s') file '%s' which exists outside of repository base directory '%s' is forbidden!", repository.getName(), repository.getId(), filePath, basePath));
        }
        return file;
    }

    public File getFileFromBase(Repository repository, ResourceStoreRequest request) throws LocalStorageException {
        try {
            return this.resolveFile(repository, request);
        }
        catch (IOException e) {
            Throwables.propagateIfPossible((Throwable)e, LocalStorageException.class);
            throw new LocalStorageException(e);
        }
    }

    protected AbstractStorageItem retrieveItemFromFile(Repository repository, ResourceStoreRequest request, File target) throws ItemNotFoundException, LocalStorageException {
        String path = request.getRequestPath();
        boolean mustBeACollection = path.endsWith("/");
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (Strings.isNullOrEmpty((String)path)) {
            path = "/";
        }
        RepositoryItemUid uid = repository.createUid(path);
        if (target.isDirectory()) {
            request.setRequestPath(path);
            DefaultStorageCollectionItem coll = new DefaultStorageCollectionItem(repository, request, target.canRead(), target.canWrite());
            long lastModified = target.lastModified();
            coll.setModified(lastModified);
            coll.setCreated(lastModified);
            return coll;
        }
        if (target.isFile() && !mustBeACollection) {
            request.setRequestPath(path);
            FileContentLocator fileContent = new FileContentLocator(target, this.getMimeSupport().guessMimeTypeFromPath(repository.getMimeRulesSource(), target.getAbsolutePath()));
            try {
                long lastModified;
                boolean isLink;
                boolean isAttribute = uid.getBooleanAttributeValue(IsItemAttributeMetacontentAttribute.class);
                boolean bl = isLink = !isAttribute && this.getLinkPersister().isLinkContent(fileContent);
                if (isLink) {
                    try {
                        DefaultStorageLinkItem link = new DefaultStorageLinkItem(repository, request, target.canRead(), target.canWrite(), this.getLinkPersister().readLinkContent(fileContent));
                        repository.getAttributesHandler().fetchAttributes(link);
                        lastModified = target.lastModified();
                        link.setModified(lastModified);
                        link.setCreated(lastModified);
                        Attributes attributes = link.getRepositoryItemAttributes();
                        if (Strings.isNullOrEmpty((String)attributes.getRemoteUrl()) && !attributes.containsKey("request.address")) {
                            repository.getAttributesHandler().touchItemLastRequested(System.currentTimeMillis(), link);
                            return link;
                        }
                    }
                    catch (NoSuchRepositoryException e) {
                        this.log.warn("Stale link object found on UID: {}, deleting it.", (Object)uid);
                        DirSupport.delete(target.toPath());
                        throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, repository, "Path %s not found in local storage of repository %s", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(repository)), (Throwable)e);
                    }
                }
                DefaultStorageFileItem file = new DefaultStorageFileItem(repository, request, target.canRead(), target.canWrite(), (ContentLocator)fileContent);
                repository.getAttributesHandler().fetchAttributes(file);
                lastModified = target.lastModified();
                file.setModified(lastModified);
                file.setCreated(lastModified);
                repository.getAttributesHandler().touchItemLastRequested(System.currentTimeMillis(), file);
                return file;
            }
            catch (FileNotFoundException e) {
                this.log.debug("File '{}' removed before finished processing the directory listing", (Object)target, (Object)e);
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, repository, "Path %s not found in local storage of repository %s", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(repository)), (Throwable)e);
            }
            catch (IOException e) {
                throw new LocalStorageException("Exception during reading up an item from FS storage!", e);
            }
        }
        throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, repository, "Path %s not found in local storage of repository %s", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(repository)));
    }

    @Override
    public boolean isReachable(Repository repository, ResourceStoreRequest request) throws LocalStorageException {
        File target = this.getBaseDir(repository, request);
        return this.getFSPeer().isReachable(repository, target, request, target);
    }

    @Override
    public boolean containsItem(Repository repository, ResourceStoreRequest request) throws LocalStorageException {
        return this.getFSPeer().containsItem(repository, this.getBaseDir(repository, request), request, this.getFileFromBase(repository, request));
    }

    @Override
    public AbstractStorageItem retrieveItem(Repository repository, ResourceStoreRequest request) throws ItemNotFoundException, LocalStorageException {
        return this.retrieveItemFromFile(repository, request, this.getFileFromBase(repository, request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void storeItem(Repository repository, StorageItem item) throws UnsupportedStorageOperationException, LocalStorageException {
        originalContentLocator = item instanceof StorageFileItem != false ? ((StorageFileItem)item).getContentLocator() : null;
        try {
            item.setStoredLocally(System.currentTimeMillis());
            item.setRemoteChecked(item.getStoredLocally());
            item.setExpired(false);
            cl = null;
            if (item instanceof StorageFileItem) {
                fItem = (StorageFileItem)item;
                this.prepareStorageFileItemForStore(fItem);
                cl = fItem.getContentLocator();
                try {
                    if (!cl.isReusable()) {
                        bufferedInputStream = new BufferedInputStream(cl.getContent()){

                            @Override
                            public void close() {
                            }
                        };
                        bufferedInputStream.mark(1024);
                        cl = new PreparedContentLocator(bufferedInputStream, cl.getMimeType(), cl.getLength());
                    } else {
                        bufferedInputStream = null;
                    }
                    if (this.getLinkPersister().isLinkContent(cl)) {
                        throw new UnsupportedStorageOperationException("Illegal Link API use on path " + item.getPath());
                    }
                    if (bufferedInputStream == null) ** GOTO lbl33
                    bufferedInputStream.reset();
                }
                catch (IOException e) {
                    throw new LocalStorageException("Link-check failed ", e);
                }
            } else if (item instanceof StorageLinkItem) {
                bos = new ByteArrayOutputStream();
                try {
                    this.getLinkPersister().writeLinkContent((StorageLinkItem)item, bos);
                }
                catch (IOException e) {
                    throw new LocalStorageException("Problem ", e);
                }
                cl = new ByteArrayContentLocator(bos.toByteArray(), "text/xml");
            }
lbl33:
            // 5 sources

            target = this.getFileFromBase(repository, item.getResourceStoreRequest());
            this.getFSPeer().storeItem(repository, this.getBaseDir(repository, item.getResourceStoreRequest()), item, target, cl);
        }
        finally {
            if (originalContentLocator instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)originalContentLocator));
            }
        }
        if (item instanceof StorageFileItem) {
            ((StorageFileItem)item).setContentLocator(new FileContentLocator(target, ((StorageFileItem)item).getMimeType()));
        }
        mdis = item instanceof StorageFileItem != false ? ((StorageFileItem)item).getContentLocator() : null;
        try {
            repository.getAttributesHandler().storeAttributes(item, mdis);
        }
        catch (IOException e) {
            throw new LocalStorageException("Cannot store attributes!", e);
        }
    }

    @Override
    public void shredItem(Repository repository, ResourceStoreRequest request) throws ItemNotFoundException, UnsupportedStorageOperationException, LocalStorageException {
        RepositoryItemUid uid = repository.createUid(request.getRequestPath());
        try {
            repository.getAttributesHandler().deleteAttributes(uid);
        }
        catch (IOException e) {
            throw new LocalStorageException("Cannot delete attributes!", e);
        }
        File target = this.getFileFromBase(repository, request);
        this.getFSPeer().shredItem(repository, this.getBaseDir(repository, request), request, target);
    }

    @Override
    public void moveItem(Repository repository, ResourceStoreRequest from, ResourceStoreRequest to) throws ItemNotFoundException, UnsupportedStorageOperationException, LocalStorageException {
        RepositoryItemUid fromUid = repository.createUid(from.getRequestPath());
        try {
            Attributes fromAttr = repository.getAttributesHandler().getAttributeStorage().getAttributes(fromUid);
            if (fromAttr != null) {
                RepositoryItemUid toUid = repository.createUid(to.getRequestPath());
                fromAttr.setRepositoryId(toUid.getRepository().getId());
                fromAttr.setPath(toUid.getPath());
                repository.getAttributesHandler().getAttributeStorage().putAttributes(toUid, fromAttr);
            }
            File fromTarget = this.getFileFromBase(repository, from);
            File toTarget = this.getFileFromBase(repository, to);
            this.getFSPeer().moveItem(repository, this.getBaseDir(repository, from), from, fromTarget, to, toTarget);
            repository.getAttributesHandler().deleteAttributes(fromUid);
        }
        catch (LocalStorageException e) {
            throw e;
        }
        catch (IOException e) {
            throw new LocalStorageException("Cannot store attributes!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StorageItem> listItems(Repository repository, ResourceStoreRequest request) throws ItemNotFoundException, LocalStorageException {
        ArrayList<StorageItem> result = new ArrayList<StorageItem>();
        File target = this.getFileFromBase(repository, request);
        Collection<File> files = this.getFSPeer().listItems(repository, this.getBaseDir(repository, request), request, target);
        if (files != null) {
            for (File file : files) {
                String newPath = PathUtils.concatPaths(request.getRequestPath(), file.getName());
                request.pushRequestPath(newPath);
                try {
                    ResourceStoreRequest collMemberReq = new ResourceStoreRequest(request);
                    try {
                        result.add(this.retrieveItemFromFile(repository, collMemberReq, file));
                    }
                    catch (ItemNotFoundException e) {
                        this.log.debug("ItemNotFoundException while listing directory, for request: {}", (Object)collMemberReq.getRequestPath(), (Object)e);
                    }
                }
                finally {
                    request.popRequestPath();
                }
            }
        } else {
            result.add(this.retrieveItemFromFile(repository, request, target));
        }
        return result;
    }

    private static File getFileFromUrl(String urlPath) {
        if (DefaultFSLocalRepositoryStorage.validFileUrl(urlPath)) {
            try {
                URL url = new URL(urlPath);
                try {
                    return new File(url.toURI());
                }
                catch (Exception t) {
                    return new File(url.getPath());
                }
            }
            catch (MalformedURLException e) {
                return new File(urlPath);
            }
        }
        return null;
    }

    private static boolean validFileUrl(String url) {
        boolean result = true;
        if (!DefaultFSLocalRepositoryStorage.validFile(new File(url))) {
            try {
                if (!DefaultFSLocalRepositoryStorage.validFile(new File(new URL(url).getFile()))) {
                    result = false;
                }
            }
            catch (MalformedURLException e) {
                result = false;
            }
        }
        return result;
    }

    private static boolean validFile(File file) {
        if (roots == null) {
            roots = new HashSet<File>();
            File[] listedRoots = File.listRoots();
            for (int i = 0; i < listedRoots.length; ++i) {
                roots.add(listedRoots[i]);
            }
            if (DefaultFSLocalRepositoryStorage.isWindows()) {
                roots.add(new File("\\\\"));
            }
        }
        File root = file;
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        return roots.contains(root);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

