/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage.local;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ChecksummingContentLocator;
import org.sonatype.nexus.proxy.item.LinkPersister;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.AbstractContextualizedRepositoryStorage;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.local.LocalRepositoryStorage;
import org.sonatype.nexus.proxy.storage.local.LocalStorageContext;
import org.sonatype.nexus.proxy.wastebasket.Wastebasket;

public abstract class AbstractLocalRepositoryStorage
extends AbstractContextualizedRepositoryStorage<LocalStorageContext>
implements LocalRepositoryStorage {
    private final Wastebasket wastebasket;
    private final LinkPersister linkPersister;
    private final MimeSupport mimeSupport;

    protected AbstractLocalRepositoryStorage(Wastebasket wastebasket, LinkPersister linkPersister, MimeSupport mimeSupport) {
        this.wastebasket = (Wastebasket)Preconditions.checkNotNull((Object)wastebasket);
        this.linkPersister = (LinkPersister)Preconditions.checkNotNull((Object)linkPersister);
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    protected Wastebasket getWastebasket() {
        return this.wastebasket;
    }

    protected LinkPersister getLinkPersister() {
        return this.linkPersister;
    }

    protected MimeSupport getMimeSupport() {
        return this.mimeSupport;
    }

    protected LocalStorageContext getLocalStorageContext(Repository repository) throws LocalStorageException {
        try {
            return super.getStorageContext(repository, repository.getLocalStorageContext());
        }
        catch (LocalStorageException e) {
            throw e;
        }
        catch (IOException e) {
            throw new LocalStorageException("Could not update context", e);
        }
    }

    @Override
    protected void updateStorageContext(Repository repository, LocalStorageContext context, AbstractContextualizedRepositoryStorage.ContextOperation contextOperation) throws IOException {
        this.updateContext(repository, context);
    }

    protected void updateContext(Repository repository, LocalStorageContext context) throws IOException {
    }

    @Override
    public URL getAbsoluteUrlFromBase(Repository repository, ResourceStoreRequest request) throws LocalStorageException {
        StringBuilder urlStr = new StringBuilder(repository.getLocalUrl());
        if (request.getRequestPath().startsWith("/")) {
            urlStr.append(request.getRequestPath());
        } else {
            urlStr.append("/").append(request.getRequestPath());
        }
        try {
            return new URL(urlStr.toString());
        }
        catch (MalformedURLException e) {
            try {
                return new File(urlStr.toString()).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                throw new LocalStorageException("The local storage has a malformed URL as baseUrl!", e);
            }
        }
    }

    @Override
    public final void deleteItem(Repository repository, ResourceStoreRequest request) throws ItemNotFoundException, UnsupportedStorageOperationException, LocalStorageException {
        this.getWastebasket().delete(this, repository, request);
    }

    protected void prepareStorageFileItemForStore(StorageFileItem item) throws LocalStorageException {
        try {
            ChecksummingContentLocator sha1cl = new ChecksummingContentLocator(item.getContentLocator(), MessageDigest.getInstance("SHA1"), "digest.sha1", item.getItemContext());
            ChecksummingContentLocator md5cl = new ChecksummingContentLocator(sha1cl, MessageDigest.getInstance("MD5"), "digest.md5", item.getItemContext());
            item.setContentLocator(md5cl);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LocalStorageException("The JVM does not support SHA1 MessageDigest or MD5 MessageDigest, that is essential for Nexus. We cannot write to local storage! Please run Nexus on JVM that does provide these MessageDigests.", e);
        }
    }
}

