/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.sonatype.nexus.proxy.storage.StorageContext;

public abstract class AbstractStorageContext
implements StorageContext {
    private final HashMap<String, Object> context = Maps.newHashMap();
    private final StorageContext parent;
    private final AtomicInteger generation;

    protected AbstractStorageContext(StorageContext parent) {
        this.parent = parent;
        this.generation = new AtomicInteger(0);
    }

    @Override
    public synchronized int getGeneration() {
        if (this.parent != null) {
            return this.parent.getGeneration() + this.generation.get();
        }
        return this.generation.get();
    }

    @Override
    public synchronized int incrementGeneration() {
        this.generation.incrementAndGet();
        return this.getGeneration();
    }

    @Override
    public StorageContext getParentStorageContext() {
        return this.parent;
    }

    @Override
    public Object getContextObject(String key) {
        return this.getContextObject(key, true);
    }

    public synchronized Object getContextObject(String key, boolean fallbackToParent) {
        if (this.context.containsKey(key)) {
            return this.context.get(key);
        }
        if (fallbackToParent && this.parent != null) {
            return this.parent.getContextObject(key);
        }
        return null;
    }

    @Override
    public synchronized Object putContextObject(String key, Object value) {
        Object previous = this.context.put(key, value);
        this.incrementGeneration();
        return previous;
    }

    @Override
    public synchronized Object removeContextObject(String key) {
        Object removed = this.context.remove(key);
        this.incrementGeneration();
        return removed;
    }

    @Override
    public boolean hasContextObject(String key) {
        return this.context.containsKey(key);
    }

    public String toString() {
        return this.getClass().getName() + "{generation=" + this.generation + ", parent=" + this.parent + "}";
    }
}

