/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.StorageContext;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractContextualizedRepositoryStorage<C extends StorageContext>
extends ComponentSupport {
    private static final String CONTEXT_UPDATED_KEY = AbstractContextualizedRepositoryStorage.class.getName() + ".updated";
    private final Map<String, Integer> repositoryContextGenerations = Maps.newConcurrentMap();

    protected AbstractContextualizedRepositoryStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected C getStorageContext(Repository repository, C context) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(context);
        C c = context;
        synchronized (c) {
            if (!this.repositoryContextGenerations.containsKey(repository.getId()) || !context.hasContextObject(CONTEXT_UPDATED_KEY) || context.getGeneration() > this.repositoryContextGenerations.get(repository.getId())) {
                ContextOperation operation;
                if (!this.repositoryContextGenerations.containsKey(repository.getId())) {
                    operation = ContextOperation.INITIALIZE;
                    this.log.trace("Storage {} is about to initialize context {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), context);
                } else {
                    operation = ContextOperation.UPDATE;
                    this.log.trace("Storage {} is about to update context {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), context);
                }
                this.updateStorageContext(repository, context, operation);
                context.putContextObject(CONTEXT_UPDATED_KEY, Boolean.TRUE);
                this.repositoryContextGenerations.put(repository.getId(), context.getGeneration());
            }
        }
        return context;
    }

    protected abstract void updateStorageContext(Repository var1, C var2, ContextOperation var3) throws IOException;

    protected static enum ContextOperation {
        INITIALIZE,
        UPDATE;

    }
}

