/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.router;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CRouting;
import org.sonatype.nexus.configuration.model.CRoutingCoreConfiguration;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.access.NexusItemAuthorizer;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.DefaultStorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.registry.RepositoryTypeDescriptor;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.router.RepositoryRouter;
import org.sonatype.nexus.proxy.router.RequestRoute;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.targets.TargetSet;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.util.PathUtils;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultRepositoryRouter
extends AbstractLastingConfigurable<CRouting>
implements RepositoryRouter {
    private final RepositoryRegistry repositoryRegistry;
    private final RepositoryTypeRegistry repositoryTypeRegistry;
    private final NexusItemAuthorizer itemAuthorizer;

    @Inject
    public DefaultRepositoryRouter(EventBus eventBus, ApplicationConfiguration applicationConfiguration, RepositoryRegistry repositoryRegistry, RepositoryTypeRegistry repositoryTypeRegistry, NexusItemAuthorizer itemAuthorizer) {
        super("Repository Router", eventBus, applicationConfiguration);
        this.repositoryRegistry = repositoryRegistry;
        this.repositoryTypeRegistry = repositoryTypeRegistry;
        this.itemAuthorizer = itemAuthorizer;
    }

    @Override
    public boolean isFollowLinks() {
        return ((CRouting)this.getCurrentConfiguration(false)).isResolveLinks();
    }

    @Override
    public void setFollowLinks(boolean followLinks) {
        ((CRouting)this.getCurrentConfiguration(true)).setResolveLinks(followLinks);
    }

    @Override
    protected void initializeConfiguration() throws ConfigurationException {
        if (this.getApplicationConfiguration().getConfigurationModel() != null) {
            this.configure(this.getApplicationConfiguration());
        }
    }

    @Override
    protected CoreConfiguration<CRouting> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CRoutingCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    @Override
    public StorageItem dereferenceLink(StorageLinkItem link) throws AccessDeniedException, ItemNotFoundException, IllegalOperationException, StorageException {
        return this.dereferenceLink(link, false, false);
    }

    @Override
    public StorageItem dereferenceLink(StorageLinkItem link, boolean localOnly, boolean remoteOnly) throws AccessDeniedException, ItemNotFoundException, IllegalOperationException, StorageException {
        this.log.debug("Dereferencing link {}", (Object)link.getTarget());
        ResourceStoreRequest req = new ResourceStoreRequest(link.getTarget().getPath(), localOnly, remoteOnly);
        req.getRequestContext().setParentContext(link.getItemContext());
        return link.getTarget().getRepository().retrieveItem(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageItem retrieveItem(ResourceStoreRequest request) throws ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        RequestRoute route = this.getRequestRouteForRequest(request);
        if (route.isRepositoryHit()) {
            StorageItem item;
            request.pushRequestPath(route.getRepositoryPath());
            try {
                item = route.getTargetedRepository().retrieveItem(request);
            }
            finally {
                request.popRequestPath();
            }
            return this.mangle(false, request, route, item);
        }
        return this.retrieveVirtualPath(request, route);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeItem(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        RequestRoute route = this.getRequestRouteForRequest(request);
        if (route.isRepositoryHit()) {
            request.pushRequestPath(route.getRepositoryPath());
            try {
                route.getTargetedRepository().storeItem(request, is, userAttributes);
            }
            finally {
                request.popRequestPath();
            }
        } else {
            throw new IllegalRequestException(request, "The path '" + request.getRequestPath() + "' does not points to any repository!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyItem(ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException, ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        RequestRoute fromRoute = this.getRequestRouteForRequest(from);
        RequestRoute toRoute = this.getRequestRouteForRequest(to);
        if (fromRoute.isRepositoryHit() && toRoute.isRepositoryHit()) {
            try {
                from.pushRequestPath(fromRoute.getRepositoryPath());
                to.pushRequestPath(toRoute.getRepositoryPath());
                if (fromRoute.getTargetedRepository() == toRoute.getTargetedRepository()) {
                    fromRoute.getTargetedRepository().copyItem(from, to);
                }
                StorageItem item = fromRoute.getTargetedRepository().retrieveItem(from);
                if (item instanceof StorageFileItem) {
                    try {
                        toRoute.getTargetedRepository().storeItem(to, ((StorageFileItem)item).getInputStream(), item.getRepositoryItemAttributes().asMap());
                    }
                    catch (IOException e) {
                        throw new LocalStorageException(e);
                    }
                }
                if (item instanceof StorageCollectionItem) {
                    toRoute.getTargetedRepository().createCollection(to, item.getRepositoryItemAttributes().asMap());
                }
                throw new IllegalRequestException(from, "Cannot copy item of class='" + item.getClass().getName() + "' over multiple repositories.");
            }
            finally {
                from.popRequestPath();
                to.popRequestPath();
            }
        } else {
            if (!fromRoute.isRepositoryHit()) {
                throw new IllegalRequestException(from, "The path '" + from.getRequestPath() + "' does not points to any repository!");
            }
            throw new IllegalRequestException(to, "The path '" + to.getRequestPath() + "' does not points to any repository!");
        }
    }

    @Override
    public void moveItem(ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException, ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        this.copyItem(from, to);
        this.deleteItem(from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StorageItem> list(ResourceStoreRequest request) throws ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        RequestRoute route = this.getRequestRouteForRequest(request);
        if (route.isRepositoryHit()) {
            Collection<StorageItem> items;
            request.pushRequestPath(route.getRepositoryPath());
            try {
                items = route.getTargetedRepository().list(request);
            }
            finally {
                request.popRequestPath();
            }
            ArrayList<StorageItem> result = new ArrayList<StorageItem>(items.size());
            for (StorageItem item : items) {
                result.add(this.mangle(true, request, route, item));
            }
            return result;
        }
        return this.listVirtualPath(request, route);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCollection(ResourceStoreRequest request, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        RequestRoute route = this.getRequestRouteForRequest(request);
        if (route.isRepositoryHit()) {
            request.pushRequestPath(route.getRepositoryPath());
            try {
                route.getTargetedRepository().createCollection(request, userAttributes);
            }
            finally {
                request.popRequestPath();
            }
        } else {
            throw new IllegalRequestException(request, "The path '" + request.getRequestPath() + "' does not points to any repository!");
        }
    }

    @Override
    public void deleteItem(ResourceStoreRequest request) throws UnsupportedStorageOperationException, ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        RequestRoute route = this.getRequestRouteForRequest(request);
        if (route.isRepositoryHit()) {
            request.pushRequestPath(route.getRepositoryPath());
            try {
                route.getTargetedRepository().deleteItem(request);
            }
            finally {
                request.popRequestPath();
            }
        } else {
            throw new IllegalRequestException(request, "The path '" + request.getRequestPath() + "' does not points to any repository!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TargetSet getTargetsForRequest(ResourceStoreRequest request) {
        TargetSet result;
        block5: {
            result = new TargetSet();
            try {
                RequestRoute route = this.getRequestRouteForRequest(request);
                if (!route.isRepositoryHit()) break block5;
                request.pushRequestPath(route.getRepositoryPath());
                try {
                    result.addTargetSet(route.getTargetedRepository().getTargetsForRequest(request));
                }
                finally {
                    request.popRequestPath();
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    protected StorageItem mangle(boolean isList, ResourceStoreRequest request, RequestRoute route, StorageItem item) throws AccessDeniedException, ItemNotFoundException, IllegalOperationException, StorageException {
        if (isList) {
            ((AbstractStorageItem)item).setPath(PathUtils.concatPaths(route.getOriginalRequestPath(), item.getName()));
        } else {
            ((AbstractStorageItem)item).setPath(route.getOriginalRequestPath());
        }
        if (this.isFollowLinks() && item instanceof StorageLinkItem) {
            return this.dereferenceLink((StorageLinkItem)item);
        }
        return item;
    }

    @Override
    public RequestRoute getRequestRouteForRequest(ResourceStoreRequest request) throws ItemNotFoundException {
        RequestRoute result = new RequestRoute();
        result.setOriginalRequestPath(request.getRequestPath());
        result.setResourceStoreRequest(request);
        String correctedPath = request.getRequestPath().startsWith("/") ? request.getRequestPath().substring(1, request.getRequestPath().length()) : request.getRequestPath();
        String[] explodedPath = null;
        explodedPath = StringUtils.isEmpty((String)correctedPath) ? new String[]{} : correctedPath.split("/");
        Class<? extends Repository> kind = null;
        result.setRequestDepth(explodedPath.length);
        if (explodedPath.length >= 1) {
            for (RepositoryTypeDescriptor rtd : this.repositoryTypeRegistry.getRegisteredRepositoryTypeDescriptors()) {
                if (!rtd.getPrefix().equals(explodedPath[0])) continue;
                kind = rtd.getRole();
                break;
            }
            if (kind == null) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, "Repository kind '" + explodedPath[0] + "' is unknown", new Object[0]));
            }
            result.setStrippedPrefix(PathUtils.concatPaths(explodedPath[0]));
        }
        if (explodedPath.length >= 2) {
            Repository repository = null;
            try {
                repository = this.getRepositoryForPathPrefixOrId(explodedPath[1], kind);
                if (!repository.isExposed()) {
                    throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, "Repository %s exists but is not exposed.", RepositoryStringUtils.getHumanizedNameString(repository)));
                }
            }
            catch (NoSuchRepositoryException e) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, e.getMessage(), new Object[0]), (Throwable)e);
            }
            result.setStrippedPrefix(PathUtils.concatPaths(explodedPath[0], explodedPath[1]));
            result.setTargetedRepository(repository);
            String repoPath = "";
            for (int i = 2; i < explodedPath.length; ++i) {
                repoPath = PathUtils.concatPaths(repoPath, explodedPath[i]);
            }
            if (result.getOriginalRequestPath().endsWith("/")) {
                repoPath = repoPath + "/";
            }
            result.setRepositoryPath(repoPath);
        }
        return result;
    }

    protected Repository getRepositoryForPathPrefixOrId(String pathPrefixOrId, Class<? extends Repository> kind) throws NoSuchRepositoryException {
        List<? extends Repository> repositories = this.repositoryRegistry.getRepositoriesWithFacet(kind);
        Repository idMatched = null;
        Repository pathPrefixMatched = null;
        for (Repository repository : repositories) {
            if (StringUtils.equals((String)repository.getId(), (String)pathPrefixOrId)) {
                idMatched = repository;
            }
            if (!StringUtils.equals((String)repository.getPathPrefix(), (String)pathPrefixOrId)) continue;
            pathPrefixMatched = repository;
        }
        if (idMatched != null) {
            return idMatched;
        }
        if (pathPrefixMatched != null) {
            return pathPrefixMatched;
        }
        throw new NoSuchRepositoryException(pathPrefixOrId);
    }

    protected StorageItem retrieveVirtualPath(ResourceStoreRequest request, RequestRoute route) throws ItemNotFoundException {
        ResourceStoreRequest req = new ResourceStoreRequest(route.getOriginalRequestPath());
        req.getRequestContext().setParentContext(request.getRequestContext());
        return new DefaultStorageCollectionItem(this, req, true, false);
    }

    protected Collection<StorageItem> listVirtualPath(ResourceStoreRequest request, RequestRoute route) throws ItemNotFoundException {
        if (route.getRequestDepth() == 0) {
            ArrayList<StorageItem> result = new ArrayList<StorageItem>();
            for (RepositoryTypeDescriptor rtd : this.repositoryTypeRegistry.getRegisteredRepositoryTypeDescriptors()) {
                if (this.repositoryRegistry.getRepositoriesWithFacet(rtd.getRole()).isEmpty()) continue;
                ResourceStoreRequest req = new ResourceStoreRequest(PathUtils.concatPaths(request.getRequestPath(), rtd.getPrefix()));
                req.getRequestContext().setParentContext(request.getRequestContext());
                DefaultStorageCollectionItem repositories = new DefaultStorageCollectionItem(this, req, true, false);
                result.add(repositories);
            }
            return result;
        }
        if (route.getRequestDepth() == 1) {
            List<Repository> repositories = null;
            Class<? extends Repository> kind = null;
            for (RepositoryTypeDescriptor rtd : this.repositoryTypeRegistry.getRegisteredRepositoryTypeDescriptors()) {
                if (!route.getStrippedPrefix().startsWith("/" + rtd.getPrefix())) continue;
                kind = rtd.getRole();
                repositories = this.repositoryRegistry.getRepositoriesWithFacet(kind);
                break;
            }
            if (repositories == null || repositories.isEmpty()) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, "No repositories found for given %s prefix!", route.getStrippedPrefix()));
            }
            repositories = this.filterAccessToRepositories((Collection<? extends Repository>)repositories);
            ArrayList<StorageItem> result = new ArrayList<StorageItem>(repositories.size());
            for (Repository repository : repositories) {
                if (!repository.isExposed() || !repository.isBrowseable()) continue;
                ResourceStoreRequest req = null;
                req = Repository.class.equals(kind) ? new ResourceStoreRequest(PathUtils.concatPaths(request.getRequestPath(), repository.getId())) : new ResourceStoreRequest(PathUtils.concatPaths(request.getRequestPath(), repository.getPathPrefix()));
                req.getRequestContext().setParentContext(request.getRequestContext());
                DefaultStorageCollectionItem repoItem = new DefaultStorageCollectionItem(this, req, true, false);
                result.add(repoItem);
            }
            return result;
        }
        throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, "BUG: request depth is bigger than 1, route=%s", route));
    }

    private List<Repository> filterAccessToRepositories(Collection<? extends Repository> repositories) {
        if (repositories == null) {
            return null;
        }
        ArrayList<Repository> filteredRepositories = new ArrayList<Repository>();
        for (Repository repository : repositories) {
            if (!this.itemAuthorizer.isViewable("repository", repository.getId())) continue;
            filteredRepositories.add(repository);
        }
        return filteredRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authorizePath(ResourceStoreRequest request, Action action) {
        block5: {
            boolean bl;
            RequestRoute route = this.getRequestRouteForRequest(request);
            if (!route.isRepositoryHit()) break block5;
            request.pushRequestPath(route.getRepositoryPath());
            try {
                bl = this.itemAuthorizer.authorizePath(route.getTargetedRepository(), request, action);
                request.popRequestPath();
            }
            catch (Throwable throwable) {
                try {
                    request.popRequestPath();
                    throw throwable;
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
            return bl;
        }
        return true;
    }
}

