/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository.validator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Scanner;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.validator.FileTypeValidator;

public class XMLUtils {
    public static FileTypeValidator.FileTypeValidity validateXmlLikeFile(StorageFileItem file, String expectedPattern) throws IOException {
        return XMLUtils.validateXmlLikeFile(file, expectedPattern, 200);
    }

    public static FileTypeValidator.FileTypeValidity validateXmlLikeFile(StorageFileItem file, String expectedPattern, int linesToCheck) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(file.getInputStream());){
            Scanner scanner = new Scanner(bis);
            for (int lineCount = 0; scanner.hasNextLine() && lineCount < linesToCheck; ++lineCount) {
                String line = scanner.nextLine();
                if (!line.contains(expectedPattern)) continue;
                FileTypeValidator.FileTypeValidity fileTypeValidity = FileTypeValidator.FileTypeValidity.VALID;
                return fileTypeValidity;
            }
        }
        return FileTypeValidator.FileTypeValidity.INVALID;
    }
}

