/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository.validator;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEventFailedFileType;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.repository.ItemContentValidator;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.validator.FileTypeValidatorHub;

@Named(value="FileTypeItemContentValidator")
@Singleton
public class FileTypeItemContentValidator
implements ItemContentValidator {
    public static final String ID = "FileTypeItemContentValidator";
    private final FileTypeValidatorHub validatorHub;

    @Inject
    public FileTypeItemContentValidator(FileTypeValidatorHub validatorHub) {
        this.validatorHub = validatorHub;
    }

    @Override
    public boolean isRemoteItemContentValid(ProxyRepository proxy, ResourceStoreRequest request, String baseUrl, AbstractStorageItem item, List<RepositoryItemValidationEvent> events) {
        if (!proxy.isFileTypeValidation()) {
            return true;
        }
        boolean result = this.validatorHub.isExpectedFileType(item);
        if (!result) {
            events.add(new RepositoryItemValidationEventFailedFileType(proxy, item, String.format("Invalid file type.", item.getRepositoryItemUid().toString())));
        }
        return result;
    }
}

