/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository.validator;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.validator.FileTypeValidator;
import org.sonatype.nexus.proxy.repository.validator.FileTypeValidatorHub;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultFileTypeValidatorHub
extends ComponentSupport
implements FileTypeValidatorHub {
    private final Map<String, FileTypeValidator> fileTypeValidators;

    @Inject
    public DefaultFileTypeValidatorHub(Map<String, FileTypeValidator> fileTypeValidators) {
        this.fileTypeValidators = fileTypeValidators;
    }

    @Override
    public boolean isExpectedFileType(StorageItem item) {
        if (item instanceof StorageFileItem) {
            StorageFileItem file = (StorageFileItem)item;
            for (Map.Entry<String, FileTypeValidator> fileTypeValidatorEntry : this.fileTypeValidators.entrySet()) {
                FileTypeValidator.FileTypeValidity validity = fileTypeValidatorEntry.getValue().isExpectedFileType(file);
                if (!FileTypeValidator.FileTypeValidity.INVALID.equals((Object)validity)) continue;
                this.log.info("File item {} evaluated as INVALID during file type validation (validator={})", (Object)file.getRepositoryItemUid().toString(), (Object)fileTypeValidatorEntry.getKey());
                return false;
            }
            return true;
        }
        return true;
    }
}

