/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository.validator;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.mime.NexusMimeTypes;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.validator.AbstractFileTypeValidator;
import org.sonatype.nexus.proxy.repository.validator.FileTypeValidator;
import org.sonatype.nexus.util.SystemPropertiesHelper;

public abstract class AbstractMimeMagicFileTypeValidator
extends AbstractFileTypeValidator {
    public static final String XML_DETECTION_LAX_KEY = FileTypeValidator.class.getName() + ".relaxedXmlValidation";
    private static final boolean XML_DETECTION_LAX = SystemPropertiesHelper.getBoolean(XML_DETECTION_LAX_KEY, true);
    private final MimeSupport mimeSupport;
    private final NexusMimeTypes mimeTypes;

    protected AbstractMimeMagicFileTypeValidator(MimeSupport mimeSupport) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
        this.mimeTypes = new NexusMimeTypes();
    }

    protected AbstractMimeMagicFileTypeValidator(NexusMimeTypes mimeTypes, MimeSupport mimeSupport) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
        this.mimeTypes = (NexusMimeTypes)Preconditions.checkNotNull((Object)mimeTypes);
    }

    protected FileTypeValidator.FileTypeValidity isExpectedFileTypeByDetectedMimeType(StorageFileItem file, Set<String> expectedMimeTypes, boolean contentOnly) throws IOException {
        if (expectedMimeTypes == null || expectedMimeTypes.isEmpty()) {
            return FileTypeValidator.FileTypeValidity.NEUTRAL;
        }
        if (file.getContentLocator().getLength() == 0L) {
            this.log.info("StorageFileItem {} MIME-magic validation failed: 0 bytes length file, no content to validate", (Object)file.getRepositoryItemUid());
            return FileTypeValidator.FileTypeValidity.INVALID;
        }
        List<String> magicMimeTypes = contentOnly ? this.mimeSupport.detectMimeTypesListFromContent(file.getContentLocator()) : this.mimeSupport.detectMimeTypesListFromContent(file);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking StorageFileItem {} is one of the expected mime types: {}, detected mime types are: {}", new Object[]{file.getRepositoryItemUid(), expectedMimeTypes, magicMimeTypes});
        }
        for (String magicMimeType : magicMimeTypes) {
            if (!expectedMimeTypes.contains(magicMimeType)) continue;
            return FileTypeValidator.FileTypeValidity.VALID;
        }
        this.log.info("StorageFileItem {} MIME-magic validation failed: expected MIME types: {}, detected MIME types: {}", new Object[]{file.getRepositoryItemUid(), expectedMimeTypes, magicMimeTypes});
        return FileTypeValidator.FileTypeValidity.INVALID;
    }

    @Override
    public FileTypeValidator.FileTypeValidity isExpectedFileType(StorageFileItem file) {
        boolean xmlLaxValidation = this.isXmlLaxValidation(file);
        String filePath = file.getPath().toLowerCase();
        HashSet<String> expectedMimeTypes = new HashSet<String>();
        NexusMimeTypes.NexusMimeType type = this.mimeTypes.getMimeTypes(filePath);
        if (type != null) {
            expectedMimeTypes.addAll(type.getMimetypes());
        }
        boolean contentOnly = (expectedMimeTypes.contains("application/xml") || expectedMimeTypes.contains("text/xml")) && !xmlLaxValidation;
        try {
            FileTypeValidator.FileTypeValidity mimeDetectionResult = this.isExpectedFileTypeByDetectedMimeType(file, expectedMimeTypes, contentOnly);
            if (FileTypeValidator.FileTypeValidity.INVALID.equals((Object)mimeDetectionResult) && xmlLaxValidation && filePath.endsWith(".xml")) {
                this.log.info("StorageFileItem {} detected as INVALID XML file but relaxed XML validation is in effect.", (Object)file.getRepositoryItemUid());
                return FileTypeValidator.FileTypeValidity.NEUTRAL;
            }
            return mimeDetectionResult;
        }
        catch (IOException e) {
            this.log.warn("Cannot detect MIME type and validate content of StorageFileItem: " + file.getRepositoryItemUid(), (Throwable)e);
            return FileTypeValidator.FileTypeValidity.NEUTRAL;
        }
    }

    protected boolean isXmlLaxValidation(StorageFileItem file) {
        boolean xmlLaxValidation = XML_DETECTION_LAX;
        if (file.getItemContext().containsKey(XML_DETECTION_LAX_KEY)) {
            xmlLaxValidation = Boolean.parseBoolean(String.valueOf(file.getItemContext().get(XML_DETECTION_LAX_KEY)));
        }
        return xmlLaxValidation;
    }
}

