/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository.threads;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.events.RepositoryRegistryRepositoryEvent;
import org.sonatype.nexus.proxy.repository.threads.ThreadPoolManager;

@Singleton
@Named
public class ThreadPoolManagerEventInspector
implements EventSubscriber {
    private final ThreadPoolManager poolManager;

    @Inject
    public ThreadPoolManagerEventInspector(ThreadPoolManager poolManager) {
        this.poolManager = (ThreadPoolManager)Preconditions.checkNotNull((Object)poolManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(RepositoryRegistryRepositoryEvent evt) {
        if (evt instanceof RepositoryRegistryEventAdd) {
            this.poolManager.createPool(evt.getRepository());
        } else if (evt instanceof RepositoryRegistryEventRemove) {
            this.poolManager.removePool(evt.getRepository());
        }
    }
}

