/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository.threads;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.threads.ThreadPoolManager;
import org.sonatype.nexus.threads.NexusExecutorService;
import org.sonatype.nexus.threads.NexusThreadFactory;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultThreadPoolManager
implements ThreadPoolManager {
    private static final int GROUP_REPOSITORY_THREAD_POOL_SIZE = SystemPropertiesHelper.getInteger("nexus.groupRepositoryThreadPoolSize", 200);
    private static final int PROXY_REPOSITORY_THREAD_POOL_SIZE = SystemPropertiesHelper.getInteger("nexus.proxyRepositoryThreadPoolSize", 50);
    private final EventBus eventBus;
    private final NexusExecutorService groupRepositoryThreadPool;
    private final NexusExecutorService proxyRepositoryThreadPool;

    @Inject
    public DefaultThreadPoolManager(EventBus eventBus) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        ThreadPoolExecutor gTarget = new ThreadPoolExecutor(0, GROUP_REPOSITORY_THREAD_POOL_SIZE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NexusThreadFactory("group", "Group TPool"), new ThreadPoolExecutor.CallerRunsPolicy());
        ThreadPoolExecutor pTarget = new ThreadPoolExecutor(0, PROXY_REPOSITORY_THREAD_POOL_SIZE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NexusThreadFactory("proxy", "Proxy TPool"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.groupRepositoryThreadPool = NexusExecutorService.forCurrentSubject(gTarget);
        this.proxyRepositoryThreadPool = NexusExecutorService.forCurrentSubject(pTarget);
        eventBus.register((Object)this);
    }

    @Override
    public ExecutorService getRepositoryThreadPool(Repository repository) {
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            return this.groupRepositoryThreadPool;
        }
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            return this.proxyRepositoryThreadPool;
        }
        return null;
    }

    @Override
    public synchronized void createPool(Repository repository) {
    }

    @Override
    public synchronized void removePool(Repository repository) {
    }

    public synchronized void shutdown() {
        this.eventBus.unregister((Object)this);
        this.terminatePool((ExecutorService)((Object)this.groupRepositoryThreadPool));
        this.terminatePool((ExecutorService)((Object)this.proxyRepositoryThreadPool));
    }

    @Subscribe
    public void on(NexusStoppedEvent e) {
        this.shutdown();
    }

    protected void terminatePool(ExecutorService executorService) {
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }
}

