/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.RepositoryStatusCheckMode;

public class RepositoryStatusCheckerThread
extends Thread {
    private final Logger logger;
    private final SystemStatus systemStatus;
    private final ProxyRepository repository;
    private volatile boolean running;

    public RepositoryStatusCheckerThread(Logger logger, SystemStatus systemStatus, ProxyRepository repository) {
        super("RepositoryStatusChecker-" + repository.getId());
        this.logger = logger;
        this.systemStatus = systemStatus;
        this.repository = repository;
        this.running = true;
    }

    public ProxyRepository getRepository() {
        return this.repository;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean val) {
        this.running = val;
    }

    @Override
    public void run() {
        boolean interrupted = false;
        while (this.isRunning() && this.getRepository().getProxyMode() != null) {
            LocalStatus repositoryLocalStatus;
            if (!this.systemStatus.isNexusStarted()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.yield();
                }
                continue;
            }
            if (!interrupted && (repositoryLocalStatus = this.getRepository().getLocalStatus()).shouldServiceRequest()) {
                RepositoryStatusCheckMode repositoryStatusCheckMode = this.getRepository().getRepositoryStatusCheckMode();
                if (RepositoryStatusCheckMode.ALWAYS.equals((Object)repositoryStatusCheckMode)) {
                    this.getRepository().getRemoteStatus(new ResourceStoreRequest("/"), true);
                } else if (RepositoryStatusCheckMode.AUTO_BLOCKED_ONLY.equals((Object)repositoryStatusCheckMode)) {
                    ProxyMode repositoryProxyMode = this.getRepository().getProxyMode();
                    if (repositoryProxyMode.shouldAutoUnblock()) {
                        this.getRepository().getRemoteStatus(new ResourceStoreRequest("/"), true);
                    }
                } else if (RepositoryStatusCheckMode.NEVER.equals((Object)repositoryStatusCheckMode)) {
                    // empty if block
                }
            }
            try {
                long sleepTime = this.getRepository().getNextRemoteStatusRetainTime();
                if (this.getRepository().getProxyMode().shouldAutoUnblock()) {
                    this.logger.info("Next attempt to auto-unblock the \"" + this.getRepository().getName() + "\" (id=" + this.getRepository().getId() + ") repository by checking its remote peer health will occur in " + DurationFormatUtils.formatDurationWords((long)sleepTime, (boolean)true, (boolean)true) + ".");
                }
                Thread.sleep(sleepTime);
                interrupted = false;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
    }
}

