/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import java.util.Collection;
import java.util.Map;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.plugins.RepositoryType;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStore;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.access.AccessManager;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.attributes.AttributesHandler;
import org.sonatype.nexus.proxy.cache.PathCache;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.RepositoryItemUidAttributeManager;
import org.sonatype.nexus.proxy.mirror.PublishedMirrors;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.repository.RepositoryMetadataManager;
import org.sonatype.nexus.proxy.repository.RepositoryWritePolicy;
import org.sonatype.nexus.proxy.repository.RequestStrategy;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.local.LocalRepositoryStorage;
import org.sonatype.nexus.proxy.storage.local.LocalStorageContext;
import org.sonatype.nexus.proxy.targets.TargetSet;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

@RepositoryType(pathPrefix="repositories")
public interface Repository
extends ResourceStore {
    public void dispose();

    public String getProviderRole();

    public String getProviderHint();

    public String getId();

    public void setId(String var1);

    public String getName();

    public void setName(String var1);

    public String getPathPrefix();

    public void setPathPrefix(String var1);

    public RepositoryKind getRepositoryKind();

    public ContentClass getRepositoryContentClass();

    @Override
    public TargetSet getTargetsForRequest(ResourceStoreRequest var1);

    public boolean hasAnyTargetsForRequest(ResourceStoreRequest var1);

    public RepositoryItemUid createUid(String var1);

    public RepositoryItemUidAttributeManager getRepositoryItemUidAttributeManager();

    public Action getResultingActionOnWrite(ResourceStoreRequest var1) throws LocalStorageException;

    public boolean isCompatible(Repository var1);

    public <F> F adaptToFacet(Class<F> var1);

    public int getNotFoundCacheTimeToLive();

    public void setNotFoundCacheTimeToLive(int var1);

    public PathCache getNotFoundCache();

    public void maintainNotFoundCache(ResourceStoreRequest var1) throws ItemNotFoundException;

    public void addToNotFoundCache(ResourceStoreRequest var1);

    public void removeFromNotFoundCache(ResourceStoreRequest var1);

    public boolean isNotFoundCacheActive();

    public void setNotFoundCacheActive(boolean var1);

    public MimeRulesSource getMimeRulesSource();

    public AttributesHandler getAttributesHandler();

    public String getLocalUrl();

    public void setLocalUrl(String var1) throws LocalStorageException;

    public LocalStatus getLocalStatus();

    public void setLocalStatus(LocalStatus var1);

    public LocalStorageContext getLocalStorageContext();

    public LocalRepositoryStorage getLocalStorage();

    public void setLocalStorage(LocalRepositoryStorage var1);

    public PublishedMirrors getPublishedMirrors();

    public RequestStrategy registerRequestStrategy(String var1, RequestStrategy var2);

    public RequestStrategy unregisterRequestStrategy(String var1);

    public Map<String, RequestStrategy> getRegisteredStrategies();

    public boolean isUserManaged();

    public void setUserManaged(boolean var1);

    public boolean isExposed();

    public void setExposed(boolean var1);

    public boolean isBrowseable();

    public void setBrowseable(boolean var1);

    public RepositoryWritePolicy getWritePolicy();

    public void setWritePolicy(RepositoryWritePolicy var1);

    public boolean isIndexable();

    public void setIndexable(boolean var1);

    public boolean isSearchable();

    public void setSearchable(boolean var1);

    public void expireCaches(ResourceStoreRequest var1);

    public boolean expireCaches(ResourceStoreRequest var1, WalkerFilter var2);

    public void expireNotFoundCaches(ResourceStoreRequest var1);

    public boolean expireNotFoundCaches(ResourceStoreRequest var1, WalkerFilter var2);

    public RepositoryMetadataManager getRepositoryMetadataManager();

    public Collection<String> evictUnusedItems(ResourceStoreRequest var1, long var2);

    public boolean recreateAttributes(ResourceStoreRequest var1, Map<String, String> var2);

    public AccessManager getAccessManager();

    @Deprecated
    public StorageItem retrieveItem(boolean var1, ResourceStoreRequest var2) throws IllegalOperationException, ItemNotFoundException, StorageException;

    @Deprecated
    public void copyItem(boolean var1, ResourceStoreRequest var2, ResourceStoreRequest var3) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException;

    @Deprecated
    public void moveItem(boolean var1, ResourceStoreRequest var2, ResourceStoreRequest var3) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException;

    @Deprecated
    public void deleteItem(boolean var1, ResourceStoreRequest var2) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException;

    @Deprecated
    public Collection<StorageItem> list(boolean var1, ResourceStoreRequest var2) throws IllegalOperationException, ItemNotFoundException, StorageException;

    public void storeItem(boolean var1, StorageItem var2) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException;

    public Collection<StorageItem> list(boolean var1, StorageCollectionItem var2) throws IllegalOperationException, ItemNotFoundException, StorageException;
}

