/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.base.Preconditions;

public class RemoteStatus {
    public static final RemoteStatus UNKNOWN = new RemoteStatus(Type.UNKNOWN);
    public static final RemoteStatus AVAILABLE = new RemoteStatus(Type.AVAILABLE);
    public static final RemoteStatus UNAVAILABLE = new RemoteStatus(Type.UNAVAILABLE);
    private final Type type;
    private final String reason;

    public RemoteStatus(Type type) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.reason = null;
    }

    public RemoteStatus(Type type, String reason) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.reason = reason;
    }

    public Type getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public String name() {
        return this.type.name();
    }

    public static RemoteStatus valueOf(String name) {
        return new RemoteStatus(Type.valueOf(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteStatus)) {
            return false;
        }
        RemoteStatus that = (RemoteStatus)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.type.toString();
    }

    public static enum Type {
        UNKNOWN,
        AVAILABLE,
        UNAVAILABLE;

    }
}

