/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import java.io.IOException;
import java.util.Map;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;

public class RecreateAttributesWalker
extends AbstractWalkerProcessor {
    public static final String FORCE_ATTRIBUTE_RECREATION = RecreateAttributesWalker.class.getName() + ".forceAttributeRecreation";
    private final Repository repository;
    private final Map<String, String> initialData;
    private boolean forceAttributeRecreation;

    public RecreateAttributesWalker(Repository repository, Map<String, String> initialData) {
        this.repository = repository;
        this.initialData = initialData;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Map<String, String> getInitialData() {
        return this.initialData;
    }

    @Override
    public void beforeWalk(WalkerContext context) throws Exception {
        this.forceAttributeRecreation = this.isForceAttributeRecreation(context);
    }

    @Override
    public final void processItem(WalkerContext context, StorageItem item) throws Exception {
        if (item instanceof StorageCollectionItem) {
            return;
        }
        this.doProcessFileItem(context, item);
    }

    protected void doProcessFileItem(WalkerContext ctx, StorageItem item) throws IOException {
        if (this.getInitialData() != null) {
            item.getRepositoryItemAttributes().putAll(this.initialData);
        }
        if (this.forceAttributeRecreation && item instanceof StorageFileItem) {
            this.getRepository().getAttributesHandler().storeAttributes(item, ((StorageFileItem)item).getContentLocator());
        } else {
            this.getRepository().getAttributesHandler().storeAttributes(item, null);
        }
    }

    protected boolean isForceAttributeRecreation(WalkerContext ctx) {
        RequestContext reqestContext = ctx.getResourceStoreRequest().getRequestContext();
        if (reqestContext.containsKey(FORCE_ATTRIBUTE_RECREATION, false)) {
            return Boolean.parseBoolean(String.valueOf(reqestContext.get(FORCE_ATTRIBUTE_RECREATION, false)));
        }
        return true;
    }
}

