/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import java.util.Collection;
import java.util.HashSet;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;

public class MutableProxyRepositoryKind
implements RepositoryKind {
    private final ProxyRepository repository;
    private RepositoryKind hostedKind;
    private RepositoryKind proxyKind;
    private HashSet<Class<?>> sharedFacets;

    public MutableProxyRepositoryKind(ProxyRepository repository) {
        this(repository, null);
    }

    public MutableProxyRepositoryKind(ProxyRepository repository, Collection<Class<?>> sharedFacets) {
        this(repository, sharedFacets, null, null);
    }

    public MutableProxyRepositoryKind(ProxyRepository repository, Collection<Class<?>> sharedFacets, RepositoryKind hostedKind, RepositoryKind proxyKind) {
        this.repository = repository;
        this.hostedKind = hostedKind;
        this.proxyKind = proxyKind;
        this.sharedFacets = new HashSet();
        if (sharedFacets != null) {
            this.sharedFacets.addAll(sharedFacets);
        }
    }

    public RepositoryKind getProxyKind() {
        return this.proxyKind;
    }

    public void setProxyKind(RepositoryKind proxyKind) {
        this.proxyKind = proxyKind;
    }

    public RepositoryKind getHostedKind() {
        return this.hostedKind;
    }

    public void setHostedKind(RepositoryKind hostedKind) {
        this.hostedKind = hostedKind;
    }

    private boolean isProxy() {
        return this.repository.getRemoteUrl() != null;
    }

    private RepositoryKind getActualRepositoryKind() {
        if (this.isProxy()) {
            return this.proxyKind;
        }
        return this.hostedKind;
    }

    @Override
    public Class<?> getMainFacet() {
        return this.getActualRepositoryKind().getMainFacet();
    }

    @Override
    public boolean isFacetAvailable(Class<?> f) {
        if (this.getActualRepositoryKind().isFacetAvailable(f)) {
            return true;
        }
        for (Class<?> facet : this.sharedFacets) {
            if (!f.isAssignableFrom(facet)) continue;
            return true;
        }
        return false;
    }
}

