/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.repository.ShadowRepository;

public class IncompatibleMasterRepositoryException
extends ConfigurationException {
    private static final long serialVersionUID = -5676236705854300582L;
    private final ShadowRepository shadow;
    private final String masterId;

    public IncompatibleMasterRepositoryException(ShadowRepository shadow, String masterId) {
        this("Master repository ID='" + masterId + "' is incompatible with shadow repository ID='" + shadow.getId() + "' because of it's ContentClass", shadow, masterId);
    }

    public IncompatibleMasterRepositoryException(String message, ShadowRepository shadow, String masterId) {
        super(message);
        this.shadow = shadow;
        this.masterId = masterId;
    }

    public ShadowRepository getShadow() {
        return this.shadow;
    }

    public String getMasterId() {
        return this.masterId;
    }
}

